/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.scheduler;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.eclipse.smarthome.core.scheduler.AbstractExpressionPart;
import org.eclipse.smarthome.core.scheduler.Expression;
import org.eclipse.smarthome.core.scheduler.ExpressionPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExpression<E extends AbstractExpressionPart>
implements Expression {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private int minimumCandidates = 10;
    private int maximumCandidates = 100;
    private String expression;
    private String delimiters;
    private ArrayList<E> expressionParts = new ArrayList();
    private boolean continueSearch;
    private ArrayList<Date> candidates = new ArrayList();
    private Date startDate = null;
    private TimeZone timeZone = null;

    public AbstractExpression(String expression, String delimiters, Date startDate, TimeZone timeZone, int minimumCandidates) throws ParseException {
        if (expression == null) {
            throw new IllegalArgumentException("The expression cannot be null");
        }
        this.expression = expression;
        this.delimiters = delimiters;
        this.startDate = startDate;
        this.timeZone = timeZone;
        this.minimumCandidates = minimumCandidates;
        if (startDate == null) {
            throw new IllegalArgumentException("The start date of the rule must not be null");
        }
        this.startDate = startDate;
        this.setTimeZone(timeZone);
        this.parseExpression(expression);
    }

    @Override
    public final Date getStartDate() {
        if (this.startDate == null) {
            this.startDate = Calendar.getInstance(this.getTimeZone()).getTime();
        }
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) throws IllegalArgumentException, ParseException {
        if (startDate == null) {
            throw new IllegalArgumentException("The start date of the rule must not be null");
        }
        this.startDate = startDate;
        this.parseExpression(this.expression);
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    @Override
    public final void setTimeZone(TimeZone timeZone) throws IllegalArgumentException, ParseException {
        if (timeZone == null) {
            throw new IllegalArgumentException("The time zone must not be null");
        }
        this.timeZone = timeZone;
        this.parseExpression(this.expression);
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expression) throws ParseException {
        this.expression = expression;
        this.parseExpression(expression);
    }

    public String toString() {
        return this.expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseExpression(String expression) throws ParseException, IllegalArgumentException {
        Object token;
        StringTokenizer expressionTokenizer = new StringTokenizer(expression, this.delimiters, false);
        int position = 0;
        this.setExpressionParts(new ArrayList());
        this.setCandidates(new ArrayList<Date>());
        while (expressionTokenizer.hasMoreTokens()) {
            token = expressionTokenizer.nextToken().trim();
            this.getExpressionParts().add(this.parseToken((String)token, ++position));
        }
        this.validateExpression();
        if (this.startDate == null) {
            this.setStartDate(Calendar.getInstance().getTime());
        }
        this.applyExpressionParts();
        token = this;
        synchronized (token) {
            this.continueSearch = true;
            while (this.getCandidates().size() < this.minimumCandidates && this.continueSearch) {
                this.populateWithSeeds();
                this.getCandidates().clear();
                this.applyExpressionParts();
            }
            this.continueSearch = false;
        }
        for (Date aDate : this.getCandidates()) {
            this.logger.trace("Final candidate {} is {}", (Object)this.getCandidates().indexOf(aDate), (Object)aDate);
        }
    }

    protected abstract void validateExpression() throws IllegalArgumentException;

    protected void applyExpressionParts() {
        Collections.sort(this.getExpressionParts());
        for (ExpressionPart part : this.getExpressionParts()) {
            this.logger.trace("Expanding {} from {} candidates", (Object)part.getClass().getSimpleName(), (Object)this.getCandidates().size());
            this.setCandidates(part.apply(this.startDate, this.getCandidates()));
            this.logger.trace("Expanded to {} candidates", (Object)this.getCandidates().size());
            for (Date aDate : this.getCandidates()) {
                this.logger.trace("Candidate {} is {}", (Object)this.getCandidates().indexOf(aDate), (Object)aDate);
            }
            this.prune();
        }
    }

    protected void prune() {
        Collections.sort(this.getCandidates());
        ArrayList<Date> beforeDates = new ArrayList<Date>();
        for (Date candidate : this.getCandidates()) {
            if (!candidate.before(this.startDate)) continue;
            beforeDates.add(candidate);
        }
        this.getCandidates().removeAll(beforeDates);
        if (this.getCandidates().size() > this.maximumCandidates) {
            this.logger.trace("Pruning {} candidates to {}", (Object)this.getCandidates().size(), (Object)this.maximumCandidates);
            int size = this.getCandidates().size();
            int i = this.maximumCandidates;
            while (i < size) {
                this.getCandidates().remove(this.getCandidates().size() - 1);
                ++i;
            }
        }
    }

    @Override
    public Date getTimeAfter(Date afterTime) {
        if (this.getCandidates().isEmpty()) {
            try {
                this.setStartDate(afterTime);
                this.parseExpression(this.expression);
            }
            catch (ParseException e) {
                this.logger.error("An exception occurred while parsing the expression : '{}'", (Object)e.getMessage());
            }
        }
        if (!this.getCandidates().isEmpty()) {
            Collections.sort(this.getCandidates());
            for (Date candidate : this.getCandidates()) {
                if (!candidate.after(afterTime)) continue;
                return candidate;
            }
        }
        return null;
    }

    @Override
    public Date getFinalFireTime() {
        if (this.getCandidates().isEmpty()) {
            try {
                this.parseExpression(this.getExpression());
            }
            catch (ParseException e) {
                this.logger.error("An exception occurred while parsing the expression : '{}'", (Object)e.getMessage());
            }
        }
        if (this.getCandidates().isEmpty()) {
            return null;
        }
        return this.getCandidates().get(this.getCandidates().size() - 1);
    }

    protected abstract E parseToken(String var1, int var2) throws ParseException;

    protected abstract void populateWithSeeds();

    public ExpressionPart getExpressionPart(Class<?> part) {
        for (ExpressionPart aPart : this.getExpressionParts()) {
            if (!aPart.getClass().equals(part)) continue;
            return aPart;
        }
        return null;
    }

    protected ArrayList<Date> getCandidates() {
        return this.candidates;
    }

    protected void setCandidates(ArrayList<Date> candidates) {
        this.candidates = candidates;
    }

    public ArrayList<E> getExpressionParts() {
        return this.expressionParts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpressionParts(ArrayList<E> expressionParts) {
        AbstractExpression abstractExpression = this;
        synchronized (abstractExpression) {
            this.expressionParts = expressionParts;
        }
    }
}

