/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.firmware.FirmwareProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirmwareRegistry {
    private final Logger logger = LoggerFactory.getLogger(FirmwareRegistry.class);
    private final List<FirmwareProvider> firmwareProviders = new CopyOnWriteArrayList<FirmwareProvider>();

    public Firmware getFirmware(FirmwareUID firmwareUID) {
        return this.getFirmware(firmwareUID, null);
    }

    public Firmware getFirmware(FirmwareUID firmwareUID, Locale locale) {
        Preconditions.checkNotNull((Object)firmwareUID, (Object)"Firmware UID must not be null");
        Locale loc = locale != null ? locale : Locale.getDefault();
        for (FirmwareProvider firmwareProvider : this.firmwareProviders) {
            try {
                Firmware firmware = firmwareProvider.getFirmware(firmwareUID, loc);
                if (firmware == null) continue;
                return firmware;
            }
            catch (Exception e) {
                this.logger.warn(String.format("Unexpected exception occurred for firmware provider %s while getting firmware for firmware UID %s.", firmwareProvider.getClass().getSimpleName(), firmwareUID), (Throwable)e);
            }
        }
        return null;
    }

    public Firmware getLatestFirmware(ThingTypeUID thingTypeUID) {
        return this.getLatestFirmware(thingTypeUID, Locale.getDefault());
    }

    public Firmware getLatestFirmware(ThingTypeUID thingTypeUID, Locale locale) {
        Locale loc = locale != null ? locale : Locale.getDefault();
        return (Firmware)Iterables.getFirst(this.getFirmwares(thingTypeUID, loc), null);
    }

    public Collection<Firmware> getFirmwares(ThingTypeUID thingTypeUID) {
        return this.getFirmwares(thingTypeUID, null);
    }

    public Collection<Firmware> getFirmwares(ThingTypeUID thingTypeUID, Locale locale) {
        Preconditions.checkNotNull((Object)thingTypeUID, (Object)"Thing type UID must not be null");
        Locale loc = locale != null ? locale : Locale.getDefault();
        TreeSet<Firmware> firmwares = new TreeSet<Firmware>();
        for (FirmwareProvider firmwareProvider : this.firmwareProviders) {
            try {
                Set<Firmware> result = firmwareProvider.getFirmwares(thingTypeUID, loc);
                if (result == null) continue;
                firmwares.addAll(result);
            }
            catch (Exception e) {
                this.logger.warn(String.format("Unexpected exception occurred for firmware provider %s while getting firmwares for thing type UID %s.", firmwareProvider.getClass().getSimpleName(), thingTypeUID), (Throwable)e);
            }
        }
        return Collections.unmodifiableCollection(firmwares);
    }

    protected void addFirmwareProvider(FirmwareProvider firmwareProvider) {
        this.firmwareProviders.add(firmwareProvider);
    }

    protected void removeFirmwareProvider(FirmwareProvider firmwareProvider) {
        this.firmwareProviders.remove(firmwareProvider);
    }
}

