/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.AbstractRegistry;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.eclipse.smarthome.core.thing.internal.BridgeImpl;
import org.eclipse.smarthome.core.thing.internal.ThingTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThingRegistryImpl
extends AbstractRegistry<Thing, ThingUID>
implements ThingRegistry {
    private Logger logger = LoggerFactory.getLogger((String)ThingRegistryImpl.class.getName());
    private List<ThingTracker> thingTrackers = new CopyOnWriteArrayList<ThingTracker>();
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();

    public void addThingTracker(ThingTracker thingTracker) {
        this.notifyTrackerAboutAllThingsAdded(thingTracker);
        this.thingTrackers.add(thingTracker);
    }

    @Override
    public Thing get(ThingUID uid) {
        for (Thing thing : this.getAll()) {
            if (!thing.getUID().equals(uid)) continue;
            return thing;
        }
        return null;
    }

    @Override
    public Channel getChannel(ChannelUID channelUID) {
        ThingUID thingUID = channelUID.getThingUID();
        Thing thing = this.get(thingUID);
        if (thing != null) {
            return thing.getChannel(channelUID.getId());
        }
        return null;
    }

    @Override
    public void updateConfiguration(ThingUID thingUID, Map<String, Object> configurationParameters) {
        ThingHandler thingHandler;
        Thing thing = this.get(thingUID);
        if (thing != null) {
            thingHandler = thing.getHandler();
            if (thingHandler == null) {
                throw new IllegalStateException("Thing with UID " + thingUID + " has no handler attached.");
            }
        } else {
            throw new IllegalArgumentException("Thing with UID " + thingUID + " does not exists.");
        }
        thingHandler.handleConfigurationUpdate(configurationParameters);
    }

    @Override
    public Thing forceRemove(ThingUID thingUID) {
        return (Thing)super.remove((Object)thingUID);
    }

    @Override
    public Thing remove(ThingUID thingUID) {
        Thing thing = this.get(thingUID);
        if (thing != null) {
            this.notifyTrackers(thing, ThingTracker.ThingTrackerEvent.THING_REMOVING);
        }
        return thing;
    }

    public void removeThingTracker(ThingTracker thingTracker) {
        this.notifyTrackerAboutAllThingsRemoved(thingTracker);
        this.thingTrackers.remove(thingTracker);
    }

    protected void notifyListenersAboutAddedElement(Thing element) {
        super.notifyListenersAboutAddedElement((Object)element);
        this.postEvent((Event)ThingEventFactory.createAddedEvent(element));
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_ADDED);
    }

    protected void notifyListenersAboutRemovedElement(Thing element) {
        super.notifyListenersAboutRemovedElement((Object)element);
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_REMOVED);
        this.postEvent((Event)ThingEventFactory.createRemovedEvent(element));
    }

    protected void notifyListenersAboutUpdatedElement(Thing oldElement, Thing element) {
        super.notifyListenersAboutUpdatedElement((Object)oldElement, (Object)element);
        this.notifyTrackers(element, ThingTracker.ThingTrackerEvent.THING_UPDATED);
        this.postEvent((Event)ThingEventFactory.createUpdateEvent(element, oldElement));
    }

    protected void onAddElement(Thing thing) throws IllegalArgumentException {
        this.addThingToBridge(thing);
        if (thing instanceof Bridge) {
            this.addThingsToBridge((Bridge)thing);
        }
    }

    protected void onRemoveElement(Thing thing) {
        Thing bridge;
        this.preserveDynamicState(thing);
        ThingUID bridgeUID = thing.getBridgeUID();
        if (bridgeUID != null && (bridge = this.get(bridgeUID)) instanceof BridgeImpl) {
            ((BridgeImpl)bridge).removeThing(thing);
        }
    }

    protected void onUpdateElement(Thing oldThing, Thing thing) {
        this.preserveDynamicState(thing);
        this.onRemoveElement(thing);
        this.onAddElement(thing);
    }

    private void preserveDynamicState(Thing thing) {
        Thing existingThing = this.get(thing.getUID());
        if (existingThing != null) {
            thing.setHandler(existingThing.getHandler());
            thing.setStatusInfo(existingThing.getStatusInfo());
        }
    }

    private void addThingsToBridge(Bridge bridge) {
        Collection things = this.getAll();
        for (Thing thing : things) {
            ThingUID bridgeUID = thing.getBridgeUID();
            if (bridgeUID == null || !bridgeUID.equals(bridge.getUID()) || !(bridge instanceof BridgeImpl) || bridge.getThings().contains(thing)) continue;
            ((BridgeImpl)bridge).addThing(thing);
        }
    }

    private void addThingToBridge(Thing thing) {
        Thing bridge;
        ThingUID bridgeUID = thing.getBridgeUID();
        if (bridgeUID != null && (bridge = this.get(bridgeUID)) instanceof BridgeImpl && !((Bridge)bridge).getThings().contains(thing)) {
            ((BridgeImpl)bridge).addThing(thing);
        }
    }

    private void notifyTrackers(Thing thing, ThingTracker.ThingTrackerEvent event) {
        for (ThingTracker thingTracker : this.thingTrackers) {
            try {
                switch (event) {
                    case THING_ADDED: {
                        thingTracker.thingAdded(thing, ThingTracker.ThingTrackerEvent.THING_ADDED);
                        break;
                    }
                    case THING_REMOVING: {
                        thingTracker.thingRemoving(thing, ThingTracker.ThingTrackerEvent.THING_REMOVING);
                        break;
                    }
                    case THING_REMOVED: {
                        thingTracker.thingRemoved(thing, ThingTracker.ThingTrackerEvent.THING_REMOVED);
                        break;
                    }
                    case THING_UPDATED: {
                        thingTracker.thingUpdated(thing, ThingTracker.ThingTrackerEvent.THING_UPDATED);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.logger.error("Could not inform the ThingTracker '" + thingTracker + "' about the '" + event.name() + "' event!", (Throwable)ex);
            }
        }
    }

    private void notifyTrackerAboutAllThingsAdded(ThingTracker thingTracker) {
        for (Thing thing : this.getAll()) {
            thingTracker.thingAdded(thing, ThingTracker.ThingTrackerEvent.TRACKER_ADDED);
        }
    }

    private void notifyTrackerAboutAllThingsRemoved(ThingTracker thingTracker) {
        for (Thing thing : this.getAll()) {
            thingTracker.thingRemoved(thing, ThingTracker.ThingTrackerEvent.TRACKER_REMOVED);
        }
    }

    @Override
    public Thing createThingOfType(ThingTypeUID thingTypeUID, ThingUID thingUID, ThingUID bridgeUID, String label, Configuration configuration) {
        this.logger.debug("Creating thing for type '{}'.", (Object)thingTypeUID);
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            if (!thingHandlerFactory.supportsThingType(thingTypeUID)) continue;
            Thing thing = thingHandlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
            thing.setLabel(label);
            return thing;
        }
        this.logger.warn("Cannot create thing. No binding found that supports creating a thing of type {}.", (Object)thingTypeUID);
        return null;
    }

    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.add(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }
}

