/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.link.AbstractLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ManagedItemChannelLinkProvider;
import org.eclipse.smarthome.core.thing.link.events.LinkEventFactory;

public class ItemChannelLinkRegistry
extends AbstractLinkRegistry<ItemChannelLink> {
    private ThingRegistry thingRegistry;

    public Set<ChannelUID> getBoundChannels(String itemName) {
        HashSet<ChannelUID> channelUIDs = new HashSet<ChannelUID>();
        for (ItemChannelLink itemChannelLink : this.getAll()) {
            if (!itemChannelLink.getItemName().equals(itemName)) continue;
            channelUIDs.add(itemChannelLink.getUID());
        }
        return channelUIDs;
    }

    public ItemChannelLink update(ItemChannelLink element) {
        throw new UnsupportedOperationException("Channels can not be updated.");
    }

    @Deprecated
    public Set<Thing> getBoundThings(String itemName) {
        HashSet<Thing> things = new HashSet<Thing>();
        Set<ChannelUID> boundChannels = this.getBoundChannels(itemName);
        for (ChannelUID channelUID : boundChannels) {
            Thing thing = this.thingRegistry.get(channelUID.getThingUID());
            if (thing == null) continue;
            things.add(thing);
        }
        return things;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    public void removeLinksForThing(ThingUID thingUID) {
        if (this.managedProvider == null) {
            throw new IllegalStateException("ManagedProvider is not available");
        }
        ((ManagedItemChannelLinkProvider)this.managedProvider).removeLinksForThing(thingUID);
    }

    protected void notifyListenersAboutAddedElement(ItemChannelLink element) {
        super.notifyListenersAboutAddedElement((Object)element);
        this.postEvent((Event)LinkEventFactory.createItemChannelLinkAddedEvent(element));
    }

    protected void notifyListenersAboutRemovedElement(ItemChannelLink element) {
        super.notifyListenersAboutRemovedElement((Object)element);
        this.postEvent((Event)LinkEventFactory.createItemChannelLinkRemovedEvent(element));
    }

    protected void notifyListenersAboutUpdatedElement(ItemChannelLink oldElement, ItemChannelLink element) {
        super.notifyListenersAboutUpdatedElement((Object)oldElement, (Object)element);
    }
}

