/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.builder.BridgeBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.GenericThingBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.dto.ChannelDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingDTO;
import org.eclipse.smarthome.core.thing.internal.BridgeImpl;
import org.eclipse.smarthome.core.thing.internal.ThingImpl;

public class ThingHelper {
    public static boolean equals(Thing a, Thing b) {
        if (!a.getUID().equals(b.getUID())) {
            return false;
        }
        if (a.getBridgeUID() == null && b.getBridgeUID() != null) {
            return false;
        }
        if (a.getBridgeUID() != null && !a.getBridgeUID().equals(b.getBridgeUID())) {
            return false;
        }
        if (a.getConfiguration() == null && b.getConfiguration() != null) {
            return false;
        }
        if (a.getConfiguration() != null && !a.getConfiguration().equals((Object)b.getConfiguration())) {
            return false;
        }
        List<Channel> channelsOfA = a.getChannels();
        List<Channel> channelsOfB = b.getChannels();
        if (channelsOfA.size() != channelsOfB.size()) {
            return false;
        }
        return ThingHelper.toString(channelsOfA).equals(ThingHelper.toString(channelsOfB));
    }

    private static String toString(List<Channel> channels) {
        ArrayList<String> strings = new ArrayList<String>(channels.size());
        for (Channel channel : channels) {
            strings.add(String.valueOf(channel.getUID().toString()) + '#' + channel.getAcceptedItemType());
        }
        Collections.sort(strings);
        return Joiner.on((char)',').join(strings);
    }

    public static void addChannelsToThing(Thing thing, Collection<Channel> channels) {
        ((ThingImpl)thing).getChannelsMutable().addAll(channels);
    }

    public static Thing merge(Thing thing, ThingDTO updatedContents) {
        GenericThingBuilder builder = thing instanceof Bridge ? BridgeBuilder.create(thing.getThingTypeUID(), thing.getUID()) : ThingBuilder.create(thing.getThingTypeUID(), thing.getUID());
        if (updatedContents.label != null) {
            builder.withLabel(updatedContents.label);
        } else {
            builder.withLabel(thing.getLabel());
        }
        if (updatedContents.bridgeUID != null) {
            builder.withBridge(new ThingUID(updatedContents.bridgeUID));
        } else {
            builder.withBridge(thing.getBridgeUID());
        }
        if (updatedContents.configuration != null && !updatedContents.configuration.keySet().isEmpty()) {
            builder.withConfiguration(new Configuration(updatedContents.configuration));
        } else {
            builder.withConfiguration(thing.getConfiguration());
        }
        if (updatedContents.properties != null) {
            builder.withProperties(updatedContents.properties);
        } else {
            builder.withProperties(thing.getProperties());
        }
        if (updatedContents.channels != null) {
            for (ChannelDTO channelDTO : updatedContents.channels) {
                builder.withChannel(ChannelDTOMapper.map(channelDTO));
            }
        } else {
            builder.withChannels(thing.getChannels());
        }
        Thing mergedThing = builder.build();
        if (mergedThing instanceof BridgeImpl && thing instanceof Bridge) {
            Bridge bridge = (Bridge)thing;
            BridgeImpl mergedBridge = (BridgeImpl)mergedThing;
            for (Thing child : bridge.getThings()) {
                mergedBridge.addThing(child);
            }
        }
        return mergedThing;
    }
}

