/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.validation.internal;

import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.eclipse.smarthome.config.core.validation.ConfigValidationMessage;
import org.eclipse.smarthome.config.core.validation.internal.ConfigDescriptionParameterValidator;
import org.eclipse.smarthome.config.core.validation.internal.MessageKey;
import org.eclipse.smarthome.config.core.validation.internal.TypeIntrospections;

final class MinMaxValidator
implements ConfigDescriptionParameterValidator {
    MinMaxValidator() {
    }

    @Override
    public ConfigValidationMessage validate(ConfigDescriptionParameter parameter, Object value) {
        int max;
        int min;
        if (value == null || parameter.getType() == ConfigDescriptionParameter.Type.BOOLEAN) {
            return null;
        }
        for (ParameterOption option : parameter.getOptions()) {
            if (!option.getValue().equals(value.toString())) continue;
            return null;
        }
        TypeIntrospections.TypeIntrospection typeIntrospection = TypeIntrospections.get(parameter.getType());
        if (parameter.getMinimum() != null && typeIntrospection.isMinViolated(value, min = parameter.getMinimum().intValue())) {
            return MinMaxValidator.createMinMaxViolationMessage(parameter.getName(), typeIntrospection.getMinViolationMessageKey(), min);
        }
        if (parameter.getMaximum() != null && typeIntrospection.isMaxViolated(value, max = parameter.getMaximum().intValue())) {
            return MinMaxValidator.createMinMaxViolationMessage(parameter.getName(), typeIntrospection.getMaxViolationMessageKey(), max);
        }
        return null;
    }

    private static ConfigValidationMessage createMinMaxViolationMessage(String parameterName, MessageKey messageKey, int minMax) {
        return new ConfigValidationMessage(parameterName, messageKey.defaultMessage, messageKey.key, minMax);
    }
}

