/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.ui;

import com.google.inject.Inject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IResourceForEditorInputFactory;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;

public class ResourceForFileEditorFactory
implements IResourceForEditorInputFactory {
    private static final ResourceSet resourceSet = new ResourceSetImpl();
    @Inject
    private IStorage2UriMapper storageToUriMapper;

    public Resource createResource(IEditorInput editorInput) {
        try {
            if (editorInput instanceof IStorageEditorInput) {
                IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
                return this.createResourceFor(storage);
            }
            throw new IllegalArgumentException("Couldn't create EMF Resource for input " + editorInput);
        }
        catch (CoreException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    private Resource createResourceFor(IStorage storage) {
        ResourceSet resourceSet = this.getResourceSet(storage);
        URI uri = this.storageToUriMapper.getUri(storage);
        XtextResource resource = this.getResource(resourceSet, uri);
        resource.setValidationDisabled(true);
        return resource;
    }

    protected ResourceSet getResourceSet(IStorage storage) {
        return resourceSet;
    }

    private XtextResource getResource(ResourceSet resourceSet, URI uri) {
        Resource aResource = resourceSet.createResource(uri, "");
        if (!(aResource instanceof XtextResource)) {
            throw new IllegalStateException("The resource factory registered for " + uri + " does not yield an XtextResource. Make sure the right resource factory has been registered.");
        }
        return (XtextResource)aResource;
    }
}

