/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.impl.DeclaredTypeFactory;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;

public class CachingDeclaredTypeFactory
implements ITypeFactory<BinaryClass, JvmDeclaredType> {
    private static final Logger log = Logger.getLogger(CachingDeclaredTypeFactory.class);
    private final DeclaredTypeFactory delegate;
    private final Map<String, JvmDeclaredType> typeCache = new ConcurrentHashMap<String, JvmDeclaredType>();
    private final JvmDeclaredType nullValue = TypesFactory.eINSTANCE.createJvmGenericType();

    public CachingDeclaredTypeFactory(DeclaredTypeFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public JvmDeclaredType createType(BinaryClass clazz) {
        try {
            JvmDeclaredType cachedResult = this.get(clazz);
            return (JvmDeclaredType)EcoreUtil2.cloneWithProxies((EObject)cachedResult);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return this.delegate.createType(clazz);
        }
    }

    private JvmDeclaredType get(BinaryClass clazz) {
        String name = clazz.getName();
        JvmDeclaredType cachedResult = this.typeCache.get(name);
        if (cachedResult == null) {
            cachedResult = this.load(clazz);
            if (cachedResult == null) {
                this.typeCache.put(name, this.nullValue);
            } else {
                this.typeCache.put(name, cachedResult);
            }
        } else if (cachedResult == this.nullValue) {
            return null;
        }
        return cachedResult;
    }

    private JvmDeclaredType load(BinaryClass key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Hit:" + key.getName()));
        }
        return this.delegate.createType(key);
    }
}

