/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.voice.internal.extensions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemNotUniqueException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;
import org.eclipse.smarthome.io.voice.tts.TTSService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SayConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private ItemRegistry itemRegistry;

    public SayConsoleCommandExtension() {
        super("say", "Speak text by a text-to-speech service (TTS).");
    }

    public List<String> getUsages() {
        return Collections.singletonList(this.buildCommandUsage("<text>", "speaks a text"));
    }

    /*
     * Unable to fully structure code
     */
    public void execute(String[] args, Console console) {
        msg = new StringBuilder();
        var7_4 = args;
        var6_5 = args.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block8: {
                word = var7_4[var5_6];
                if (word.startsWith("%") && word.endsWith("%") && word.length() > 2) {
                    itemName = word.substring(1, word.length() - 1);
                    try {
                        item = this.itemRegistry.getItemByPattern(itemName);
                        msg.append(item.getState().toString());
                        break block8;
                    }
                    catch (ItemNotFoundException v0) {
                        console.println("Error: Item '" + itemName + "' does not exist.");
                        break block8;
                    }
                    catch (ItemNotUniqueException e) {
                        console.print("Error: Multiple items match this pattern: ");
                        ** for (item : e.getMatchingItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        console.print(String.valueOf(item.getName()) + " ");
                        continue;
lbl22:
                        // 1 sources

                        break block8;
                    }
                }
                msg.append(word);
            }
            msg.append(" ");
            ++var5_6;
        }
        context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ttsService = SayConsoleCommandExtension.getTTSService(context);
        if (ttsService != null) {
            ttsService.say(msg.toString(), null, null);
            console.println("Said: " + msg);
        } else {
            console.println("No TTS service available - tried to say: " + msg);
        }
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    private static TTSService getTTSService(BundleContext context) {
        if (context != null) {
            try {
                Collection refs = context.getServiceReferences(TTSService.class, null);
                if (refs != null && refs.size() > 0) {
                    return (TTSService)context.getService((ServiceReference)refs.iterator().next());
                }
                return null;
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return null;
    }
}

