/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.smarthome.model.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.SitemapPackage;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.model.validation.AbstractSitemapValidator;
import org.eclipse.xtext.validation.Check;

public class SitemapValidator
extends AbstractSitemapValidator {
    @Check
    public void checkFramesInFrame(Frame frame) {
        EList<Widget> _children = frame.getChildren();
        for (Widget w : _children) {
            if (!(w instanceof Frame)) continue;
            EStructuralFeature _eStructuralFeature = SitemapPackage.Literals.FRAME.getEStructuralFeature(6);
            this.error("Frames must not contain other frames", _eStructuralFeature);
            return;
        }
    }

    @Check
    public void checkFramesInWidgetList(Sitemap sitemap) {
        boolean containsFrames = false;
        boolean containsOtherWidgets = false;
        EList<Widget> _children = sitemap.getChildren();
        for (Widget w : _children) {
            if (w instanceof Frame) {
                containsFrames = true;
            } else {
                containsOtherWidgets = true;
            }
            if (!containsFrames || !containsOtherWidgets) continue;
            EStructuralFeature _eStructuralFeature = SitemapPackage.Literals.FRAME.getEStructuralFeature(3);
            this.error("Sitemap should contain either only frames or none at all", _eStructuralFeature);
            return;
        }
    }

    @Check
    public void checkFramesInWidgetList(LinkableWidget widget) {
        if (widget instanceof Frame) {
            return;
        }
        boolean containsFrames = false;
        boolean containsOtherWidgets = false;
        EList<Widget> _children = widget.getChildren();
        for (Widget w : _children) {
            if (w instanceof Frame) {
                containsFrames = true;
            } else {
                containsOtherWidgets = true;
            }
            if (!containsFrames || !containsOtherWidgets) continue;
            EStructuralFeature _eStructuralFeature = SitemapPackage.Literals.FRAME.getEStructuralFeature(6);
            this.error("Linkable widget should contain either only frames or none at all", _eStructuralFeature);
            return;
        }
    }
}

