/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;

public class LineRegion
extends TextSegment
implements ILineRegion {
    public LineRegion(ITextRegionAccess regionAccess, int offset, int length) {
        super(regionAccess, offset, length);
    }

    @Override
    public ITextSegment getIndentation() {
        String text = this.getText();
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return new TextSegment(this.getTextRegionAccess(), this.getOffset(), i);
            }
            ++i;
        }
        return new TextSegment(this.getTextRegionAccess(), this.getOffset(), 0);
    }

    @Override
    public ILineRegion getNextLine() {
        ITextRegionAccess access = this.getTextRegionAccess();
        int start = this.getEndOffset() + 1;
        String text = access.regionForDocument().getText();
        while (true) {
            if (start >= text.length()) {
                return null;
            }
            char c = text.charAt(start);
            if (c != '\n' && c != '\r') break;
            ++start;
        }
        int end = text.indexOf(10, start);
        if (end > 0) {
            if (text.charAt(end - 1) == '\r') {
                --end;
            }
        } else {
            end = text.length();
        }
        return new LineRegion(access, start, end - start);
    }

    @Override
    public ILineRegion getPreviousLine() {
        ITextRegionAccess access = this.getTextRegionAccess();
        int end = this.getOffset() - 1;
        String text = access.regionForDocument().getText();
        while (true) {
            if (end < 0) {
                return null;
            }
            char c = text.charAt(end);
            if (c != '\n' && c != '\r') break;
            --end;
        }
        int start = text.lastIndexOf(10, end);
        if (start < 0) {
            start = 0;
        }
        return new LineRegion(access, start, end - start);
    }
}

