/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.generator.trace.AbsoluteURI;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegionToString;
import org.eclipse.xtext.generator.trace.AbstractURIWrapper;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForURIProvider;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.internal.LocationInResource;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;

public abstract class AbstractTrace
implements ITrace {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceRegistry;
    private AbstractTraceRegion rootTraceRegion;
    private ITraceRegionProvider traceRegionProvider;
    private boolean isTraceToSource;

    public final AbstractTraceRegion getRootTraceRegion() {
        if (this.rootTraceRegion == null) {
            this.rootTraceRegion = this.doGetRootTraceRegion();
        }
        return this.rootTraceRegion;
    }

    @Override
    public boolean hasTraceData() {
        return this.getRootTraceRegion() != null;
    }

    public void setTraceToSource(boolean isTraceToSource) {
        this.isTraceToSource = isTraceToSource;
    }

    public boolean isTraceToSource() {
        return this.isTraceToSource;
    }

    public boolean isTraceToTarget() {
        return !this.isTraceToSource;
    }

    protected AbstractTraceRegion doGetRootTraceRegion() {
        try {
            return this.traceRegionProvider.getTraceRegion();
        }
        catch (TraceNotFoundException noTraceFound) {
            return null;
        }
    }

    public void setTraceRegionProvider(ITraceRegionProvider traceRegionProvider) {
        this.traceRegionProvider = traceRegionProvider;
    }

    protected ITraceRegionProvider getTraceRegionProvider() {
        return this.traceRegionProvider;
    }

    @Override
    public ILocationInResource getBestAssociatedLocation(ITextRegion region) {
        AbstractTraceRegion right = this.findTraceRegionAtRightOffset(region.getOffset() + region.getLength());
        if (right != null && this.encloses(right, region.getOffset(), true) && right.getMyOffset() + right.getMyLength() == region.getOffset() + region.getLength()) {
            return this.getMergedLocationInResource(right);
        }
        AbstractTraceRegion left = this.findTraceRegionAtLeftOffset(region.getOffset());
        return this.mergeRegions(left, right);
    }

    protected ILocationInResource mergeRegions(AbstractTraceRegion left, AbstractTraceRegion right) {
        SourceRelativeURI rightToPath;
        if (left == null) {
            if (right != null) {
                return this.getMergedLocationInResource(right);
            }
            return null;
        }
        if (right == null || left.equals(right)) {
            return this.getMergedLocationInResource(left);
        }
        SourceRelativeURI leftToPath = left.getAssociatedSrcRelativePath();
        if (ObjectExtensions.operator_equals((Object)leftToPath, (Object)(rightToPath = right.getAssociatedSrcRelativePath()))) {
            ITextRegionWithLineInformation rightRegion;
            ITextRegionWithLineInformation leftRegion = left.getMyRegion();
            if (leftRegion.contains((ITextRegion)(rightRegion = right.getMyRegion()))) {
                return this.getMergedLocationInResource(left);
            }
            if (rightRegion.contains((ITextRegion)leftRegion)) {
                return this.getMergedLocationInResource(right);
            }
            AbstractTraceRegion parent = left.getParent();
            AbstractTraceRegion leftChild = left;
            while (parent != null) {
                if (parent.getMyRegion().contains((ITextRegion)rightRegion)) break;
                leftChild = parent;
                parent = parent.getParent();
            }
            if (parent != null) {
                ILocationData merged;
                AbstractTraceRegion rightChild = right;
                while (!parent.equals(rightChild.getParent())) {
                    if ((rightChild = rightChild.getParent()) != null) continue;
                    return this.getMergedLocationInResource(leftChild);
                }
                SourceRelativeURI path = leftToPath;
                if (path == null) {
                    path = leftChild.getAssociatedSrcRelativePath();
                }
                if ((merged = parent.getMergedAssociatedLocation()) != null) {
                    return this.createLocationInResource(merged, path);
                }
            }
        }
        return null;
    }

    protected ILocationInResource createLocationInResource(ITextRegionWithLineInformation region, SourceRelativeURI srcRelativePath) {
        return new LocationInResource(region.getOffset(), region.getLength(), region.getLineNumber(), region.getEndLineNumber(), srcRelativePath, this);
    }

    protected ILocationInResource getMergedLocationInResource(AbstractTraceRegion region) {
        ILocationData locationData = region.getMergedAssociatedLocation();
        if (locationData != null) {
            return this.createLocationInResourceFor(locationData, region);
        }
        return null;
    }

    protected ILocationInResource createLocationInResourceFor(ILocationData location, AbstractTraceRegion traceRegion) {
        SourceRelativeURI path = location.getSrcRelativePath();
        if (path == null) {
            path = traceRegion.getAssociatedSrcRelativePath();
        }
        if (path == null) {
            return null;
        }
        return this.createLocationInResource(location, path);
    }

    protected AbsoluteURI resolvePath(SourceRelativeURI path) {
        return new AbsoluteURI(path.getURI().resolve(this.getLocalProjectConfig().getPath()));
    }

    public AbstractTraceRegion findTraceRegionAtRightOffset(int offset) {
        return this.findTraceRegionAt(offset, true);
    }

    /*
     * Unable to fully structure code
     */
    protected AbstractTraceRegion findTraceRegionAt(int offset, boolean includeRegionEnd) {
        candidate = this.getRootTraceRegion();
        if (candidate != null && this.encloses(candidate, offset, includeRegionEnd)) ** GOTO lbl14
        return null;
lbl-1000:
        // 1 sources

        {
            children = candidate.getNestedRegions();
            if (children.isEmpty()) {
                return candidate;
            }
            for (AbstractTraceRegion child : children) {
                if (this.encloses(child, offset, includeRegionEnd)) {
                    candidate = child;
                    continue block0;
                }
                if (child.getMyOffset() <= offset) continue;
                return candidate;
            }
            return candidate;
lbl14:
            // 2 sources

            ** while (candidate != null)
        }
lbl15:
        // 1 sources

        return null;
    }

    public AbstractTraceRegion findTraceRegionAtLeftOffset(int offset) {
        return this.findTraceRegionAt(offset, false);
    }

    public boolean encloses(AbstractTraceRegion region, int offset, boolean includeRegionEnd) {
        return this.encloses(region.getMyOffset(), region.getMyLength(), offset, includeRegionEnd);
    }

    public boolean encloses(int regionOffset, int regionLength, int offset, boolean includeRegionEnd) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset may not be negative");
        }
        int relativeOffset = offset - regionOffset;
        boolean result = relativeOffset == 0 || relativeOffset > 0 && !(includeRegionEnd ? relativeOffset > regionLength : relativeOffset >= regionLength);
        return result;
    }

    @Override
    public Iterable<? extends ILocationInResource> getAllAssociatedLocations(ITextRegion localRegion) {
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions(localRegion);
        return this.toLocations(allTraceRegions);
    }

    @Override
    public ILocationInResource getBestAssociatedLocation(ITextRegion localRegion, AbsoluteURI uri) {
        IProjectConfig projectConfig = this.getLocalProjectConfig();
        AbstractTraceRegion left = this.findTraceRegionAtLeftOffset(localRegion.getOffset());
        left = this.findParentByURI(left, uri, projectConfig);
        AbstractTraceRegion right = this.findTraceRegionAtRightOffset(localRegion.getOffset() + localRegion.getLength());
        right = this.findParentByURI(right, uri, projectConfig);
        return this.mergeRegions(left, right);
    }

    protected boolean isAssociatedWith(AbstractTraceRegion region, AbsoluteURI uri, IProjectConfig project) {
        ITraceURIConverter traceURIConverter = this.getService(uri, ITraceURIConverter.class);
        if (traceURIConverter == null) {
            traceURIConverter = this.getService(this.getLocalURI(), ITraceURIConverter.class);
        }
        SourceRelativeURI convertedUri = traceURIConverter.getURIForTrace(project, uri);
        return convertedUri.equals(region.getAssociatedSrcRelativePath());
    }

    protected AbstractTraceRegion findParentByURI(AbstractTraceRegion region, AbsoluteURI uri, IProjectConfig project) {
        while (region != null && !this.isAssociatedWith(region, uri, project)) {
            region = region.getParent();
        }
        return region;
    }

    @Override
    public Iterable<? extends ILocationInResource> getAllAssociatedLocations(ITextRegion localRegion, AbsoluteURI uri) {
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions(localRegion);
        TraceRegionsByURI filteredByURI = new TraceRegionsByURI(allTraceRegions, uri, this.getLocalProjectConfig());
        return this.toLocations(filteredByURI);
    }

    @Override
    public Iterable<? extends ILocationInResource> getAllAssociatedLocations(AbsoluteURI uri) {
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions();
        TraceRegionsByURI filteredByURI = new TraceRegionsByURI(allTraceRegions, uri, this.getLocalProjectConfig());
        return this.toLocations(filteredByURI);
    }

    @Override
    public LanguageInfo getLocalLanguage() {
        return this.findLanguage(this.getLocalURI());
    }

    @Override
    public abstract AbsoluteURI getLocalURI();

    @Override
    public SourceRelativeURI getSrcRelativeLocalURI() {
        return this.getLocalURI().deresolve(this.getLocalProjectConfig());
    }

    @Override
    public abstract IProjectConfig getLocalProjectConfig();

    protected Iterable<? extends ILocationInResource> toLocations(final Iterable<AbstractTraceRegion> allTraceRegions) {
        return new Iterable<ILocationInResource>(){

            @Override
            public Iterator<ILocationInResource> iterator() {
                return new AbstractIterator<ILocationInResource>(allTraceRegions){
                    private Iterator<AbstractTraceRegion> delegate;
                    private AbstractTraceRegion region;
                    private Iterator<ILocationData> locationDelegate;
                    {
                        this.delegate = iterable.iterator();
                    }

                    protected ILocationInResource computeNext() {
                        block2: {
                            ILocationInResource result;
                            while (true) {
                                if ((this.locationDelegate == null || !this.locationDelegate.hasNext()) && this.delegate.hasNext()) {
                                    this.region = this.delegate.next();
                                    this.locationDelegate = this.region.getAssociatedLocations().iterator();
                                    if (!this.locationDelegate.hasNext()) continue;
                                }
                                if (this.locationDelegate == null || !this.locationDelegate.hasNext()) break block2;
                                ILocationData locationData = this.locationDelegate.next();
                                result = AbstractTrace.this.createLocationInResourceFor(locationData, this.region);
                                if (result != null) break;
                            }
                            return result;
                        }
                        return (ILocationInResource)this.endOfData();
                    }
                };
            }
        };
    }

    protected Iterable<AbstractTraceRegion> getAllTraceRegions(ITextRegion localRegion) {
        final AbstractTraceRegion left = this.findTraceRegionAtLeftOffset(localRegion.getOffset());
        final int end = localRegion.getOffset() + localRegion.getLength();
        if (left == null) {
            return Collections.emptyList();
        }
        return new Iterable<AbstractTraceRegion>(){

            @Override
            public Iterator<AbstractTraceRegion> iterator() {
                AbstractTraceRegion root = AbstractTrace.this.getRootTraceRegion();
                if (root == null) {
                    return ImmutableSet.of().iterator();
                }
                final Iterator<AbstractTraceRegion> allLeafs = root.leafIterator();
                AbstractIterator<AbstractTraceRegion> result = new AbstractIterator<AbstractTraceRegion>(left){
                    AbstractTraceRegion first;
                    {
                        while (this.first == null && iterator.hasNext()) {
                            AbstractTraceRegion next = (AbstractTraceRegion)iterator.next();
                            if (next.getMyOffset() != abstractTraceRegion.getMyOffset()) continue;
                            this.first = next;
                            break;
                        }
                    }

                    protected AbstractTraceRegion computeNext() {
                        if (this.first != null) {
                            AbstractTraceRegion result = this.first;
                            this.first = null;
                            return result;
                        }
                        if (!allLeafs.hasNext()) {
                            return (AbstractTraceRegion)this.endOfData();
                        }
                        AbstractTraceRegion candidate = (AbstractTraceRegion)allLeafs.next();
                        if (candidate.getMyOffset() >= end) {
                            return (AbstractTraceRegion)this.endOfData();
                        }
                        return candidate;
                    }
                };
                return result;
            }
        };
    }

    @Override
    public Iterable<? extends ILocationInResource> getAllAssociatedLocations() {
        Iterable<AbstractTraceRegion> allTraceRegions = this.getAllTraceRegions();
        return this.toLocations(allTraceRegions);
    }

    protected Iterable<AbstractTraceRegion> getAllTraceRegions() {
        return new Iterable<AbstractTraceRegion>(){

            @Override
            public Iterator<AbstractTraceRegion> iterator() {
                AbstractTraceRegion root = AbstractTrace.this.getRootTraceRegion();
                if (root == null) {
                    return ImmutableSet.of().iterator();
                }
                Iterator<AbstractTraceRegion> result = root.leafIterator();
                return result;
            }
        };
    }

    protected abstract InputStream getContents(SourceRelativeURI var1) throws IOException;

    protected abstract Reader getContentsAsText(SourceRelativeURI var1) throws IOException;

    protected abstract Reader getLocalContentsAsText() throws IOException;

    protected LanguageInfo findLanguage(AbstractURIWrapper uri) {
        return this.getService(uri, LanguageInfo.class);
    }

    protected <T> T getService(AbstractURIWrapper uri, Class<T> type) {
        if (uri == null) {
            return null;
        }
        IResourceServiceProvider serviceProvider = this.resourceServiceRegistry.getResourceServiceProvider(uri.getURI());
        if (serviceProvider != null) {
            return serviceProvider.get(type);
        }
        return null;
    }

    public String toString() {
        return new AbstractTraceRegionToString(){

            @Override
            protected AbstractTraceRegion getTrace() {
                return AbstractTrace.this.getRootTraceRegion();
            }

            @Override
            protected String getRemoteText(SourceRelativeURI uri) {
                try {
                    return CharStreams.toString((Readable)AbstractTrace.this.getContentsAsText(uri));
                }
                catch (IOException e) {
                    Exceptions.sneakyThrow((Throwable)e);
                    return "";
                }
            }

            @Override
            protected String getLocalText() {
                try {
                    return CharStreams.toString((Readable)AbstractTrace.this.getLocalContentsAsText());
                }
                catch (IOException e) {
                    Exceptions.sneakyThrow((Throwable)e);
                    return "";
                }
            }

            @Override
            protected String getLocalTitle() {
                return AbstractTrace.this.getLocalURI().getURI().lastSegment();
            }
        }.toString();
    }

    protected static class TraceAccess
    implements Function<SourceRelativeURI, ITrace> {
        private final boolean traceToSource;
        private final ITraceForURIProvider traceProvider;
        private final IProjectConfig project;

        public TraceAccess(boolean traceToSource, IProjectConfig project, ITraceForURIProvider traceProvider) {
            this.traceToSource = traceToSource;
            this.project = project;
            this.traceProvider = traceProvider;
        }

        public ITrace apply(SourceRelativeURI relativeURI) {
            if (this.traceToSource) {
                return this.traceProvider.getTraceToSource(relativeURI, this.project);
            }
            return this.traceProvider.getTraceToTarget(relativeURI, this.project);
        }
    }

    protected class TraceRegionsByURI
    implements Iterable<AbstractTraceRegion> {
        private final Iterable<? extends AbstractTraceRegion> allTraceRegions;
        private final AbsoluteURI uri;
        private final IProjectConfig projectConfig;

        public TraceRegionsByURI(Iterable<? extends AbstractTraceRegion> allTraceRegions, AbsoluteURI uri, IProjectConfig projectConfig) {
            this.allTraceRegions = allTraceRegions;
            this.uri = uri;
            this.projectConfig = projectConfig;
        }

        @Override
        public Iterator<AbstractTraceRegion> iterator() {
            Iterator<? extends AbstractTraceRegion> result = this.allTraceRegions.iterator();
            Iterator languageSpecificWithDuplicates = Iterators.transform(result, (Function)new Function<AbstractTraceRegion, AbstractTraceRegion>(){

                public AbstractTraceRegion apply(AbstractTraceRegion input) {
                    return AbstractTrace.this.findParentByURI(input, TraceRegionsByURI.this.uri, TraceRegionsByURI.this.projectConfig);
                }
            });
            UnmodifiableIterator withoutDuplicates = Iterators.filter((Iterator)languageSpecificWithDuplicates, (Predicate)new Predicate<AbstractTraceRegion>(){
                private AbstractTraceRegion previous = null;

                public boolean apply(AbstractTraceRegion input) {
                    if (input == null || input.equals(this.previous)) {
                        return false;
                    }
                    this.previous = input;
                    return true;
                }
            });
            return withoutDuplicates;
        }
    }
}

