/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

public class Channel {
    private String acceptedItemType;
    private ChannelUID uid;
    private ChannelTypeUID channelTypeUID;
    private String label;
    private String description;
    private Configuration configuration;
    private Map<String, String> properties;
    private Set<String> defaultTags = new LinkedHashSet<String>();

    Channel() {
    }

    public Channel(ChannelUID uid, String acceptedItemType) {
        this.uid = uid;
        this.acceptedItemType = acceptedItemType;
        this.configuration = new Configuration();
        this.properties = Collections.unmodifiableMap(new HashMap(0));
    }

    public Channel(ChannelUID uid, String acceptedItemType, Configuration configuration) {
        this(uid, null, acceptedItemType, configuration, new HashSet<String>(0), null, null, null);
    }

    public Channel(ChannelUID uid, String acceptedItemType, Set<String> defaultTags) {
        this(uid, null, acceptedItemType, null, defaultTags == null ? new HashSet<String>(0) : defaultTags, null, null, null);
    }

    public Channel(ChannelUID uid, String acceptedItemType, Configuration configuration, Set<String> defaultTags, Map<String, String> properties) {
        this(uid, null, acceptedItemType, null, defaultTags == null ? new HashSet<String>(0) : defaultTags, properties, null, null);
    }

    public Channel(ChannelUID uid, ChannelTypeUID channelTypeUID, String acceptedItemType, Configuration configuration, Set<String> defaultTags, Map<String, String> properties, String label, String description) {
        this.uid = uid;
        this.channelTypeUID = channelTypeUID;
        this.acceptedItemType = acceptedItemType;
        this.configuration = configuration;
        this.label = label;
        this.description = description;
        this.properties = properties;
        this.defaultTags = Collections.unmodifiableSet(new HashSet<String>(defaultTags));
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.properties == null) {
            this.properties = Collections.unmodifiableMap(new HashMap(0));
        }
    }

    public String getAcceptedItemType() {
        return this.acceptedItemType;
    }

    public ChannelUID getUID() {
        return this.uid;
    }

    public ChannelTypeUID getChannelTypeUID() {
        return this.channelTypeUID;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Set<String> getDefaultTags() {
        return this.defaultTags;
    }
}

