/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.dto;

import java.util.ArrayList;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.dto.ChannelDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingDTO;
import org.eclipse.smarthome.core.thing.util.ThingHelper;

public class ThingDTOMapper {
    public static ThingDTO map(Thing thing) {
        ArrayList<ChannelDTO> channelDTOs = new ArrayList<ChannelDTO>();
        for (Channel channel : thing.getChannels()) {
            ChannelDTO channelDTO = ChannelDTOMapper.map(channel);
            channelDTOs.add(channelDTO);
        }
        String thingTypeUID = thing.getThingTypeUID().getAsString();
        String thingUID = thing.getUID().toString();
        String bridgeUID = thing.getBridgeUID() != null ? thing.getBridgeUID().toString() : null;
        return new ThingDTO(thingTypeUID, thingUID, thing.getLabel(), bridgeUID, channelDTOs, thing.getConfiguration(), thing.getProperties());
    }

    public static Thing map(ThingDTO thingDTO) {
        ThingUID thingUID = new ThingUID(thingDTO.UID);
        ThingTypeUID thingTypeUID = thingDTO.thingTypeUID == null ? new ThingTypeUID("") : new ThingTypeUID(thingDTO.thingTypeUID);
        Thing thing = ThingBuilder.create(thingTypeUID, thingUID).build();
        return ThingHelper.merge(thing, thingDTO);
    }
}

