/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.normalization;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.smarthome.config.core.normalization.AbstractNormalizer;

final class IntNormalizer
extends AbstractNormalizer {
    IntNormalizer() {
    }

    @Override
    public Object doNormalize(Object value) {
        try {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).setScale(0, RoundingMode.UNNECESSARY);
            }
            if (value instanceof Byte) {
                return new BigDecimal(((Byte)value).byteValue());
            }
            if (value instanceof Integer) {
                return new BigDecimal((Integer)value);
            }
            if (value instanceof Long) {
                return BigDecimal.valueOf((Long)value);
            }
            if (value instanceof String) {
                return new BigDecimal((String)value).setScale(0, RoundingMode.UNNECESSARY);
            }
            if (value instanceof Float) {
                return new BigDecimal(((Float)value).toString()).setScale(0, RoundingMode.UNNECESSARY);
            }
            if (value instanceof Double) {
                return BigDecimal.valueOf((Double)value).setScale(0, RoundingMode.UNNECESSARY);
            }
        }
        catch (ArithmeticException | NumberFormatException e) {
            this.logger.trace("\"{}\" is not a valid integer number.", (Object)e, value);
            return value;
        }
        this.logger.trace("Class \"{}\" cannot be converted to an integer number.", (Object)value.getClass().getName());
        return value;
    }
}

