/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.core.status;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.smarthome.config.core.status.ConfigStatusMessage;

public final class ConfigStatusInfo {
    private final Collection<ConfigStatusMessage> configStatusMessages = new ArrayList<ConfigStatusMessage>();

    public ConfigStatusInfo() {
    }

    public ConfigStatusInfo(Collection<ConfigStatusMessage> configStatusMessages) {
        this.add(configStatusMessages);
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages() {
        return Collections.unmodifiableCollection(this.configStatusMessages);
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages(ConfigStatusMessage.Type ... types) {
        ImmutableList typesCollection = ImmutableList.copyOf((Object[])types);
        return this.filter((Collection<?>)typesCollection, new Predicate<ConfigStatusMessage>((Collection)typesCollection){
            private final /* synthetic */ Collection val$typesCollection;
            {
                this.val$typesCollection = collection;
            }

            public boolean apply(ConfigStatusMessage configStatusMessage) {
                return this.val$typesCollection.contains((Object)configStatusMessage.type);
            }
        });
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages(String ... parameterNames) {
        ImmutableList parameterNamesCollection = ImmutableList.copyOf((Object[])parameterNames);
        return this.filter((Collection<?>)parameterNamesCollection, new Predicate<ConfigStatusMessage>((Collection)parameterNamesCollection){
            private final /* synthetic */ Collection val$parameterNamesCollection;
            {
                this.val$parameterNamesCollection = collection;
            }

            public boolean apply(ConfigStatusMessage configStatusMessage) {
                return this.val$parameterNamesCollection.contains(configStatusMessage.parameterName);
            }
        });
    }

    public Collection<ConfigStatusMessage> getConfigStatusMessages(final Collection<ConfigStatusMessage.Type> types, final Collection<String> parameterNames) {
        Preconditions.checkNotNull(types);
        Preconditions.checkNotNull(parameterNames);
        return ConfigStatusInfo.filterConfigStatusMessages(this.getConfigStatusMessages(), new Predicate<ConfigStatusMessage>(){

            public boolean apply(ConfigStatusMessage configStatusMessage) {
                return types.contains((Object)configStatusMessage.type) || parameterNames.contains(configStatusMessage.parameterName);
            }
        });
    }

    public void add(ConfigStatusMessage configStatusMessage) {
        if (configStatusMessage == null) {
            throw new IllegalArgumentException("Config status message must not be null");
        }
        this.configStatusMessages.add(configStatusMessage);
    }

    public void add(Collection<ConfigStatusMessage> configStatusMessages) {
        if (configStatusMessages == null) {
            throw new IllegalArgumentException("Config status messages must not be null");
        }
        for (ConfigStatusMessage configStatusMessage : configStatusMessages) {
            this.add(configStatusMessage);
        }
    }

    private Collection<ConfigStatusMessage> filter(Collection<?> filter, Predicate<ConfigStatusMessage> predicate) {
        if (filter.isEmpty()) {
            return this.getConfigStatusMessages();
        }
        return ConfigStatusInfo.filterConfigStatusMessages(this.getConfigStatusMessages(), predicate);
    }

    private static Collection<ConfigStatusMessage> filterConfigStatusMessages(Collection<ConfigStatusMessage> configStatusMessages, Predicate<ConfigStatusMessage> predicate) {
        return Collections.unmodifiableCollection(Collections2.filter(configStatusMessages, predicate));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.configStatusMessages == null ? 0 : this.configStatusMessages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigStatusInfo other = (ConfigStatusInfo)obj;
        return !(this.configStatusMessages == null ? other.configStatusMessages != null : !this.configStatusMessages.equals(other.configStatusMessages));
    }

    public String toString() {
        return "ConfigStatusInfo [configStatusMessages=" + this.configStatusMessages + "]";
    }
}

