/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.transform;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationHelper {
    private static final Logger logger = LoggerFactory.getLogger(TransformationHelper.class);
    protected static final Pattern EXTRACT_TRANSFORMFUNCTION_PATTERN = Pattern.compile("(.*?)\\((.*)\\):(.*)");

    public static boolean isTransform(String pattern) {
        return EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(pattern).matches();
    }

    public static TransformationService getTransformationService(BundleContext context, String transformationType) {
        if (context != null) {
            Logger logger = LoggerFactory.getLogger(TransformationHelper.class);
            String filter = "(smarthome.transform=" + transformationType + ")";
            try {
                Collection refs = context.getServiceReferences(TransformationService.class, filter);
                if (refs != null && refs.size() > 0) {
                    return (TransformationService)context.getService((ServiceReference)refs.iterator().next());
                }
                logger.warn("Cannot get service reference for transformation service of type " + transformationType);
            }
            catch (InvalidSyntaxException e) {
                logger.warn("Cannot get service reference for transformation service of type " + transformationType, (Throwable)e);
            }
        }
        return null;
    }

    public static String transform(BundleContext context, String stateDescPattern, String state) {
        Matcher matcher = EXTRACT_TRANSFORMFUNCTION_PATTERN.matcher(stateDescPattern);
        if (matcher.find()) {
            String type = matcher.group(1);
            String pattern = matcher.group(2);
            String value = matcher.group(3);
            TransformationService transformation = TransformationHelper.getTransformationService(context, type);
            if (transformation != null) {
                value = String.format(value, state);
                try {
                    pattern = transformation.transform(pattern, value);
                }
                catch (TransformationException e) {
                    logger.warn("transformation throws exception [transformation=" + transformation + ", value=" + value + "]", (Throwable)e);
                    pattern = state;
                }
            } else {
                logger.warn("couldn't transform value  because transformationService of type '{}' is unavailable", (Object)type);
                pattern = state;
            }
            return pattern;
        }
        return state;
    }
}

