/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.internal.core.provider.AutomationResourceBundlesEventQueue;
import org.eclipse.smarthome.automation.internal.core.provider.Vendor;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceBundleProvider<E>
implements ServiceTrackerCustomizer {
    protected static String PATH = "ESH-INF/automation";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BundleContext bc;
    protected String path;
    protected ServiceTracker<Parser, Parser> parserTracker;
    protected Map<String, Parser<E>> parsers = new HashMap<String, Parser<E>>();
    protected Map<String, E> providedObjectsHolder = new HashMap<String, E>();
    protected Map<Vendor, List<String>> providerPortfolio = new HashMap<Vendor, List<String>>();
    protected Map<Bundle, List<URL>> waitingProviders = new HashMap<Bundle, List<URL>>();
    protected AutomationResourceBundlesEventQueue queue;
    protected I18nProvider i18nProvider;

    public AbstractResourceBundleProvider(BundleContext context) {
        this.bc = context;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.parserTracker = new ServiceTracker(context, Parser.class.getName(), (ServiceTrackerCustomizer)this);
        this.parserTracker.open();
    }

    public void setQueue(AutomationResourceBundlesEventQueue queue) {
        this.queue = queue;
        queue.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        Parser service = (Parser)this.bc.getService(reference);
        String key = (String)reference.getProperty("format");
        key = key == null ? "json" : key;
        this.parsers.put(key, service);
        Map<Bundle, List<URL>> map = this.waitingProviders;
        synchronized (map) {
            for (Bundle bundle : this.waitingProviders.keySet()) {
                if (bundle.getState() == 1) continue;
                this.queue.addingBundle(bundle, null);
            }
        }
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        String key = (String)reference.getProperty("format");
        key = key == null ? "json" : key;
        this.parsers.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.parserTracker != null) {
            this.parserTracker.close();
            this.parserTracker = null;
            this.parsers = null;
        }
        Map<Object, Object> map = this.providedObjectsHolder;
        synchronized (map) {
            this.providedObjectsHolder = null;
        }
        map = this.providerPortfolio;
        synchronized (map) {
            this.providerPortfolio = null;
        }
        map = this.waitingProviders;
        synchronized (map) {
            this.waitingProviders = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProviderProcessed(Bundle bundle) {
        boolean res = false;
        Map<Bundle, List<URL>> map = this.waitingProviders;
        synchronized (map) {
            res = this.waitingProviders.get(bundle) == null;
        }
        if (res) {
            Vendor vendor = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
            Map<Vendor, List<String>> map2 = this.providerPortfolio;
            synchronized (map2) {
                res = this.providerPortfolio.get(vendor) != null;
            }
        }
        return res;
    }

    public boolean isReady() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAutomationProvider(Bundle bundle) {
        Vendor vendor2;
        Map<Vendor, List<String>> map = this.providerPortfolio;
        synchronized (map) {
            for (Vendor vendor2 : this.providerPortfolio.keySet()) {
                if (!vendor2.getVendorSymbolicName().equals(bundle.getSymbolicName())) continue;
                List<String> portfolio = this.providerPortfolio.remove(vendor2);
                if (portfolio == null || portfolio.isEmpty()) break;
                for (String uid : portfolio) {
                    Map<String, E> map2 = this.providedObjectsHolder;
                    synchronized (map2) {
                        this.providedObjectsHolder.remove(uid);
                    }
                }
            }
        }
        Enumeration urlEnum = null;
        try {
            urlEnum = bundle.findEntries(this.path, null, true);
        }
        catch (IllegalStateException e) {
            this.logger.debug("Can't read from resource of bundle with ID {}. The bundle is uninstalled.", (Object)bundle.getBundleId(), (Object)e);
            this.processAutomationProviderUninstalled(bundle);
        }
        if (urlEnum == null) {
            return;
        }
        vendor2 = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
        while (urlEnum.hasMoreElements()) {
            URL url = (URL)urlEnum.nextElement();
            String parserType = this.getParserType(url);
            Parser<E> parser = this.parsers.get(parserType);
            Map<Bundle, List<URL>> map3 = this.waitingProviders;
            synchronized (map3) {
                block34: {
                    List<URL> urlList = this.waitingProviders.get(bundle);
                    if (parser != null) {
                        if (urlList != null && urlList.remove(url) && urlList.isEmpty()) {
                            this.waitingProviders.remove(bundle);
                        }
                        InputStreamReader reader = null;
                        try {
                            try {
                                reader = new InputStreamReader(url.openStream());
                                this.importData(vendor2, parser, reader);
                            }
                            catch (IOException e) {
                                this.logger.error("Can't read from resource of bundle with ID {}", (Object)bundle.getBundleId(), (Object)e);
                                this.processAutomationProviderUninstalled(bundle);
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block34;
                            }
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    } else if (parser == null) {
                        if (urlList == null) {
                            urlList = new ArrayList<URL>();
                        }
                        urlList.add(url);
                        this.waitingProviders.put(bundle, urlList);
                    }
                }
            }
        }
    }

    protected String getParserType(URL url) {
        String fileName = url.getPath();
        int fileExtesionStartIndex = fileName.lastIndexOf(".") + 1;
        if (fileExtesionStartIndex == -1) {
            return "json";
        }
        String fileExtesion = fileName.substring(fileExtesionStartIndex);
        if (fileExtesion.equals("txt")) {
            return "json";
        }
        return fileExtesion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAutomationProviderUninstalled(Bundle bundle) {
        Map<Bundle, List<URL>> map = this.waitingProviders;
        synchronized (map) {
            this.waitingProviders.remove(bundle);
        }
        List<String> portfolio = null;
        Vendor vendor = new Vendor(bundle.getSymbolicName(), bundle.getVersion().toString());
        Map<Vendor, List<String>> map2 = this.providerPortfolio;
        synchronized (map2) {
            portfolio = this.providerPortfolio.remove(vendor);
        }
        if (portfolio != null && !portfolio.isEmpty()) {
            for (String uid : portfolio) {
                Map<String, E> map3 = this.providedObjectsHolder;
                synchronized (map3) {
                    this.providedObjectsHolder.remove(uid);
                }
            }
        }
    }

    protected Bundle getBundle(String uid) {
        String symbolicName = null;
        for (Map.Entry<Vendor, List<String>> entry : this.providerPortfolio.entrySet()) {
            if (!entry.getValue().contains(uid)) continue;
            symbolicName = entry.getKey().getVendorSymbolicName();
            break;
        }
        Bundle[] bundles = this.bc.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i].getSymbolicName().equals(symbolicName)) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    protected abstract Set<E> importData(Vendor var1, Parser<E> var2, InputStreamReader var3);
}

