/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.AutomationResourceBundlesEventQueue;
import org.eclipse.smarthome.automation.internal.core.provider.Vendor;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ConfigDescriptionParameterI18nUtil;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleI18nUtil;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleTypeI18nUtil;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ModuleTypeResourceBundleProvider
extends AbstractResourceBundleProvider<ModuleType>
implements ModuleTypeProvider {
    protected ModuleTypeRegistry moduleTypeRegistry;
    private ServiceTracker moduleTypesTracker;
    private ServiceRegistration mtpReg;
    private ServiceTracker localizationTracker;

    public ModuleTypeResourceBundleProvider(BundleContext context) {
        super(context);
        this.path = String.valueOf(PATH) + "/moduletypes/";
        this.moduleTypesTracker = new ServiceTracker(context, ModuleTypeRegistry.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                ModuleTypeResourceBundleProvider.this.moduleTypeRegistry = (ModuleTypeRegistry)ModuleTypeResourceBundleProvider.this.bc.getService(reference);
                ModuleTypeResourceBundleProvider.this.queue.open();
                return ModuleTypeResourceBundleProvider.this.moduleTypeRegistry;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                ModuleTypeResourceBundleProvider.this.moduleTypeRegistry = null;
            }
        });
        this.localizationTracker = new ServiceTracker(this.bc, I18nProvider.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                ModuleTypeResourceBundleProvider.this.i18nProvider = (I18nProvider)ModuleTypeResourceBundleProvider.this.bc.getService(reference);
                return ModuleTypeResourceBundleProvider.this.i18nProvider;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                ModuleTypeResourceBundleProvider.this.i18nProvider = null;
            }
        });
        this.localizationTracker.open();
    }

    @Override
    public void setQueue(AutomationResourceBundlesEventQueue queue) {
        super.setQueue(queue);
        this.moduleTypesTracker.open();
    }

    @Override
    public void close() {
        if (this.localizationTracker != null) {
            this.localizationTracker.close();
            this.localizationTracker = null;
            this.i18nProvider = null;
        }
        if (this.moduleTypesTracker != null) {
            this.moduleTypesTracker.close();
            this.moduleTypesTracker = null;
            this.moduleTypeRegistry = null;
        }
        if (this.mtpReg != null) {
            this.mtpReg.unregister();
            this.mtpReg = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ModuleType> T getModuleType(String UID, Locale locale) {
        ModuleType defModuleType = null;
        Map map = this.providedObjectsHolder;
        synchronized (map) {
            defModuleType = (ModuleType)this.providedObjectsHolder.get(UID);
        }
        if (defModuleType != null) {
            ModuleType mt = this.getPerLocale(defModuleType, locale);
            return (T)mt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ModuleType> getModuleTypes(Locale locale) {
        ArrayList<ModuleType> moduleTypesList = new ArrayList<ModuleType>();
        Map map = this.providedObjectsHolder;
        synchronized (map) {
            for (ModuleType defModuleType : this.providedObjectsHolder.values()) {
                ModuleType mt;
                if (defModuleType == null || (mt = this.getPerLocale(defModuleType, locale)) == null) continue;
                moduleTypesList.add(mt);
            }
        }
        return moduleTypesList;
    }

    @Override
    public Object addingService(ServiceReference reference) {
        if (reference.getProperty("parser.type").equals("parser.module.type")) {
            return super.addingService(reference);
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.moduleTypeRegistry != null && this.queue != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<ModuleType> importData(Vendor vendor, Parser<ModuleType> parser, InputStreamReader inputStreamReader) {
        ArrayList<String> portfolio = null;
        if (vendor != null) {
            Map map = this.providerPortfolio;
            synchronized (map) {
                portfolio = (ArrayList<String>)this.providerPortfolio.get(vendor);
                if (portfolio == null) {
                    portfolio = new ArrayList<String>();
                    this.providerPortfolio.put(vendor, portfolio);
                }
            }
        }
        Set providedObjects = null;
        try {
            providedObjects = parser.parse(inputStreamReader);
        }
        catch (ParsingException e) {
            this.logger.error("ModuleType parsing error!", (Throwable)e);
        }
        if (providedObjects != null && !providedObjects.isEmpty()) {
            for (ModuleType providedObject : providedObjects) {
                String uid;
                if (providedObject == null || this.checkExistence(uid = providedObject.getUID())) continue;
                if (portfolio != null) {
                    portfolio.add(uid);
                }
                Map map = this.providedObjectsHolder;
                synchronized (map) {
                    this.providedObjectsHolder.put(uid, providedObject);
                }
            }
            Hashtable properties = new Hashtable();
            ((Dictionary)properties).put("module.types", this.providedObjectsHolder.keySet());
            if (this.mtpReg == null) {
                this.mtpReg = this.bc.registerService(ModuleTypeProvider.class.getName(), (Object)this, properties);
            } else {
                this.mtpReg.setProperties(properties);
            }
        }
        return providedObjects;
    }

    private boolean checkExistence(String uid) {
        if (this.moduleTypeRegistry.get(uid) != null) {
            this.logger.error("Module Type with UID \"{}\" already exists! Failed to create a second with the same UID!", (Object)uid, (Object)new IllegalArgumentException());
            return true;
        }
        return false;
    }

    private ModuleType getPerLocale(ModuleType defModuleType, Locale locale) {
        if (locale == null) {
            return defModuleType;
        }
        String uid = defModuleType.getUID();
        Bundle bundle = this.getBundle(uid);
        String llabel = ModuleTypeI18nUtil.getLocalizedModuleTypeLabel(this.i18nProvider, bundle, uid, defModuleType.getLabel(), locale);
        String ldescription = ModuleTypeI18nUtil.getLocalizedModuleTypeDescription(this.i18nProvider, bundle, uid, defModuleType.getDescription(), locale);
        List<ConfigDescriptionParameter> lconfigDescriptions = ConfigDescriptionParameterI18nUtil.getLocalizedConfigurationDescription(this.i18nProvider, defModuleType.getConfigurationDescription(), bundle, uid, "module-type.", locale);
        if (defModuleType instanceof ActionType) {
            return this.createLocalizedActionType((ActionType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        if (defModuleType instanceof ConditionType) {
            return this.createLocalizedConditionType((ConditionType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        if (defModuleType instanceof TriggerType) {
            return this.createLocalizedTriggerType((TriggerType)defModuleType, bundle, uid, locale, lconfigDescriptions, llabel, ldescription);
        }
        return null;
    }

    private ActionType createLocalizedActionType(ActionType at, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Input> inputs = ModuleTypeI18nUtil.getLocalizedInputs(this.i18nProvider, at.getInputs(), bundle, moduleTypeUID, locale);
        List<Output> outputs = ModuleTypeI18nUtil.getLocalizedOutputs(this.i18nProvider, at.getOutputs(), bundle, moduleTypeUID, locale);
        ActionType lat = null;
        if (at instanceof CompositeActionType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeActionType)at).getChildren(), bundle, moduleTypeUID, "module-type.", locale);
            lat = new CompositeActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs, modules);
        } else {
            lat = new ActionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, at.getTags(), at.getVisibility(), inputs, outputs);
        }
        return lat;
    }

    private ConditionType createLocalizedConditionType(ConditionType ct, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Input> inputs = ModuleTypeI18nUtil.getLocalizedInputs(this.i18nProvider, ct.getInputs(), bundle, moduleTypeUID, locale);
        ConditionType lct = null;
        if (ct instanceof CompositeConditionType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeConditionType)ct).getChildren(), bundle, moduleTypeUID, "module-type.", locale);
            lct = new CompositeConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs, modules);
        } else {
            lct = new ConditionType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, ct.getTags(), ct.getVisibility(), inputs);
        }
        return lct;
    }

    private TriggerType createLocalizedTriggerType(TriggerType tt, Bundle bundle, String moduleTypeUID, Locale locale, List<ConfigDescriptionParameter> lconfigDescriptions, String llabel, String ldescription) {
        List<Output> outputs = ModuleTypeI18nUtil.getLocalizedOutputs(this.i18nProvider, tt.getOutputs(), bundle, moduleTypeUID, locale);
        TriggerType ltt = null;
        if (tt instanceof CompositeTriggerType) {
            List modules = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((CompositeTriggerType)tt).getChildren(), bundle, moduleTypeUID, "module-type.", locale);
            ltt = new CompositeTriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs, modules);
        } else {
            ltt = new TriggerType(moduleTypeUID, lconfigDescriptions, llabel, ldescription, tt.getTags(), tt.getVisibility(), outputs);
        }
        return ltt;
    }
}

