/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.internal.core.provider;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.automation.internal.core.provider.AbstractResourceBundleProvider;
import org.eclipse.smarthome.automation.internal.core.provider.AutomationResourceBundlesEventQueue;
import org.eclipse.smarthome.automation.internal.core.provider.Vendor;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ConfigDescriptionParameterI18nUtil;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.ModuleI18nUtil;
import org.eclipse.smarthome.automation.internal.core.provider.i18n.RuleTemplateI18nUtil;
import org.eclipse.smarthome.automation.parser.Parser;
import org.eclipse.smarthome.automation.parser.ParsingException;
import org.eclipse.smarthome.automation.template.RuleTemplate;
import org.eclipse.smarthome.automation.template.Template;
import org.eclipse.smarthome.automation.template.TemplateProvider;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class TemplateResourceBundleProvider
extends AbstractResourceBundleProvider<Template>
implements TemplateProvider {
    protected TemplateRegistry templateRegistry;
    protected ModuleTypeRegistry moduleTypeRegistry;
    private ServiceTracker tracker;
    private ServiceRegistration tpReg;
    private ServiceTracker localizationTracker;

    public TemplateResourceBundleProvider(BundleContext context) {
        super(context);
        this.path = String.valueOf(PATH) + "/templates/";
        try {
            Filter filter = this.bc.createFilter("(|(objectClass=" + TemplateRegistry.class.getName() + ")(objectClass=" + ModuleTypeRegistry.class.getName() + "))");
            this.tracker = new ServiceTracker(this.bc, filter, new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    Object service = TemplateResourceBundleProvider.this.bc.getService(reference);
                    if (service instanceof TemplateRegistry) {
                        TemplateResourceBundleProvider.this.templateRegistry = (TemplateRegistry)service;
                    } else {
                        TemplateResourceBundleProvider.this.moduleTypeRegistry = (ModuleTypeRegistry)service;
                    }
                    TemplateResourceBundleProvider.this.queue.open();
                    return service;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                    if (service == TemplateResourceBundleProvider.this.templateRegistry) {
                        TemplateResourceBundleProvider.this.templateRegistry = null;
                    } else {
                        TemplateResourceBundleProvider.this.moduleTypeRegistry = null;
                    }
                }
            });
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.localizationTracker = new ServiceTracker(this.bc, I18nProvider.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                TemplateResourceBundleProvider.this.i18nProvider = (I18nProvider)TemplateResourceBundleProvider.this.bc.getService(reference);
                return TemplateResourceBundleProvider.this.i18nProvider;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                TemplateResourceBundleProvider.this.i18nProvider = null;
            }
        });
        this.localizationTracker.open();
    }

    @Override
    public void setQueue(AutomationResourceBundlesEventQueue queue) {
        super.setQueue(queue);
        this.tracker.open();
    }

    @Override
    public void close() {
        if (this.localizationTracker != null) {
            this.localizationTracker.close();
            this.localizationTracker = null;
            this.i18nProvider = null;
        }
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
            this.moduleTypeRegistry = null;
            this.templateRegistry = null;
        }
        if (this.tpReg != null) {
            this.tpReg.unregister();
            this.tpReg = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Template> T getTemplate(String UID, Locale locale) {
        Template defTemplate = null;
        Map map = this.providerPortfolio;
        synchronized (map) {
            defTemplate = (Template)this.providedObjectsHolder.get(UID);
        }
        if (defTemplate != null) {
            Template t = this.getPerLocale(defTemplate, locale);
            return (T)t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Template> getTemplates(Locale locale) {
        ArrayList<Template> templatesList = new ArrayList<Template>();
        Map map = this.providedObjectsHolder;
        synchronized (map) {
            for (Template defTemplate : this.providedObjectsHolder.values()) {
                Template t;
                if (defTemplate == null || (t = this.getPerLocale(defTemplate, locale)) == null) continue;
                templatesList.add(t);
            }
        }
        return templatesList;
    }

    @Override
    public Object addingService(ServiceReference reference) {
        if (reference.getProperty("parser.type").equals("parser.template")) {
            return super.addingService(reference);
        }
        return null;
    }

    @Override
    public boolean isReady() {
        return this.moduleTypeRegistry != null && this.templateRegistry != null && this.queue != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<Template> importData(Vendor vendor, Parser<Template> parser, InputStreamReader inputStreamReader) {
        ArrayList<String> portfolio = null;
        if (vendor != null) {
            Map map = this.providerPortfolio;
            synchronized (map) {
                portfolio = (ArrayList<String>)this.providerPortfolio.get(vendor);
                if (portfolio == null) {
                    portfolio = new ArrayList<String>();
                    this.providerPortfolio.put(vendor, portfolio);
                }
            }
        }
        Set providedObjects = null;
        try {
            providedObjects = parser.parse(inputStreamReader);
        }
        catch (ParsingException e) {
            this.logger.error("Template parsing of vendor {} is faild!", (Object)vendor, (Object)e);
        }
        if (providedObjects != null && !providedObjects.isEmpty()) {
            for (Template ruleT : providedObjects) {
                String uid = ruleT.getUID();
                if (this.checkExistence(uid)) continue;
                if (portfolio != null) {
                    portfolio.add(uid);
                }
                Map map = this.providedObjectsHolder;
                synchronized (map) {
                    this.providedObjectsHolder.put(uid, ruleT);
                }
            }
            Hashtable properties = new Hashtable();
            ((Dictionary)properties).put("rule.templates", this.providedObjectsHolder.keySet());
            if (this.tpReg == null) {
                this.tpReg = this.bc.registerService(TemplateProvider.class.getName(), (Object)this, properties);
            } else {
                this.tpReg.setProperties(properties);
            }
        }
        return providedObjects;
    }

    private boolean checkExistence(String uid) {
        if (this.templateRegistry != null && this.templateRegistry.get(uid) != null) {
            this.logger.error("Rule Template with UID \"{}\" already exists! Failed to create a second with the same UID!", (Object)uid, (Object)new IllegalArgumentException());
            return true;
        }
        return false;
    }

    private Template getPerLocale(Template defTemplate, Locale locale) {
        if (locale == null) {
            return defTemplate;
        }
        String uid = defTemplate.getUID();
        Bundle bundle = this.getBundle(uid);
        if (defTemplate instanceof RuleTemplate) {
            String llabel = RuleTemplateI18nUtil.getLocalizedRuleTemplateLabel(this.i18nProvider, bundle, uid, defTemplate.getLabel(), locale);
            String ldescription = RuleTemplateI18nUtil.getLocalizedRuleTemplateDescription(this.i18nProvider, bundle, uid, defTemplate.getDescription(), locale);
            List<ConfigDescriptionParameter> lconfigDescriptions = ConfigDescriptionParameterI18nUtil.getLocalizedConfigurationDescription(this.i18nProvider, ((RuleTemplate)defTemplate).getConfigurationDescription(), bundle, uid, "rule-template.", locale);
            List lactions = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((RuleTemplate)defTemplate).getActions(), bundle, uid, "rule-template.", locale);
            List lconditions = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((RuleTemplate)defTemplate).getConditions(), bundle, uid, "rule-template.", locale);
            List ltriggers = ModuleI18nUtil.getLocalizedModules(this.i18nProvider, ((RuleTemplate)defTemplate).getTriggers(), bundle, uid, "rule-template.", locale);
            return new RuleTemplate(uid, llabel, ldescription, ((RuleTemplate)defTemplate).getTags(), ltriggers, lconditions, lactions, lconfigDescriptions, ((RuleTemplate)defTemplate).getVisibility());
        }
        return null;
    }
}

