/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.fsinternetradio.internal.radio;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.binding.fsinternetradio.internal.radio.FrontierSiliconRadioApiResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontierSiliconRadioConnection {
    private final Logger logger = LoggerFactory.getLogger(FrontierSiliconRadioConnection.class);
    private static final int SOCKET_TIMEOUT = 5000;
    private final String hostname;
    private final int port;
    private final String pin;
    private String sessionId;
    private HttpClient httpClient = null;
    private boolean isLoggedIn = false;

    public FrontierSiliconRadioConnection(String hostname, int port, String pin) {
        this.hostname = hostname;
        this.port = port;
        this.pin = pin;
    }

    public boolean doLogin() throws IOException {
        this.isLoggedIn = false;
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        String url = "http://" + this.hostname + ":" + this.port + "/fsapi/CREATE_SESSION?pin=" + this.pin;
        this.logger.trace("opening URL:" + url);
        GetMethod method = new GetMethod(url);
        method.getParams().setSoTimeout(5000);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        try {
            FrontierSiliconRadioApiResult result;
            int statusCode = this.httpClient.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                this.logger.debug("Communication with radio failed: " + method.getStatusLine());
                if (method.getStatusCode() == 403) {
                    throw new RuntimeException("Radio does not allow connection, maybe wrong pin?");
                }
                throw new IOException("Communication with radio failed, return code: " + statusCode);
            }
            String responseBody = IOUtils.toString((InputStream)method.getResponseBodyAsStream());
            if (!responseBody.isEmpty()) {
                this.logger.trace("login response: " + responseBody);
            }
            if ((result = new FrontierSiliconRadioApiResult(responseBody)).isStatusOk()) {
                this.logger.trace("login successful");
                this.sessionId = result.getSessionId();
                this.isLoggedIn = true;
                return true;
            }
        }
        catch (HttpException he) {
            this.logger.debug("Fatal protocol violation: {}", (Object)he.toString());
            throw he;
        }
        catch (IOException ioe) {
            this.logger.debug("Fatal transport error: {}", (Object)ioe.toString());
            throw ioe;
        }
        finally {
            method.releaseConnection();
        }
        return false;
    }

    public FrontierSiliconRadioApiResult doRequest(String requestString) throws IOException {
        return this.doRequest(requestString, null);
    }

    public FrontierSiliconRadioApiResult doRequest(String requestString, String params) throws IOException {
        int i = 0;
        while (i < 2) {
            if (this.isLoggedIn || this.doLogin()) {
                String url = "http://" + this.hostname + ":" + this.port + "/fsapi/" + requestString + "?pin=" + this.pin + "&sid=" + this.sessionId + (params == null || params.trim().length() == 0 ? "" : "&" + params);
                this.logger.trace("calling url: '" + url + "'");
                GetMethod method = new GetMethod(url);
                method.getParams().setSoTimeout(5000);
                method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(2, false));
                try {
                    int statusCode = this.httpClient.executeMethod((HttpMethod)method);
                    if (statusCode != 200) {
                        this.logger.warn("Method failed: " + method.getStatusLine());
                        this.isLoggedIn = false;
                        method.releaseConnection();
                    } else {
                        String responseBody = IOUtils.toString((InputStream)method.getResponseBodyAsStream());
                        if (responseBody.isEmpty()) {
                            this.logger.debug("got empty result");
                            this.isLoggedIn = false;
                            method.releaseConnection();
                        } else {
                            this.logger.trace("got result: " + responseBody);
                            FrontierSiliconRadioApiResult result = new FrontierSiliconRadioApiResult(responseBody);
                            if (result.isStatusOk()) {
                                FrontierSiliconRadioApiResult frontierSiliconRadioApiResult = result;
                                return frontierSiliconRadioApiResult;
                            }
                            this.isLoggedIn = false;
                            method.releaseConnection();
                        }
                    }
                }
                catch (HttpException he) {
                    this.logger.error("Fatal protocol violation: {}", (Object)he.toString());
                    this.isLoggedIn = false;
                    throw he;
                }
                catch (IOException ioe) {
                    this.logger.error("Fatal transport error: {}", (Object)ioe.toString());
                    throw ioe;
                }
                finally {
                    method.releaseConnection();
                }
            }
            ++i;
        }
        this.isLoggedIn = false;
        return null;
    }
}

