/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.xml.osgi;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.xml.osgi.AbstractAsyncBundleProcessor;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProviderFactory;
import org.eclipse.smarthome.config.xml.util.XmlDocumentReader;
import org.eclipse.smarthome.core.thing.BundleProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDocumentBundleTracker<T>
extends BundleTracker<Bundle> {
    private final Logger logger = LoggerFactory.getLogger(XmlDocumentBundleTracker.class);
    private final String xmlDirectory;
    private final XmlDocumentReader<T> xmlDocumentTypeReader;
    private final XmlDocumentProviderFactory<T> xmlDocumentProviderFactory;
    private final Map<Bundle, XmlDocumentProvider<T>> bundleDocumentProviderMap;
    private final AbstractAsyncBundleProcessor asyncLoader;
    private BundleContext bundleContext;
    private ServiceRegistration asyncLoaderRegistration;

    public XmlDocumentBundleTracker(BundleContext bundleContext, String xmlDirectory, XmlDocumentReader<T> xmlDocumentTypeReader, XmlDocumentProviderFactory<T> xmlDocumentProviderFactory) throws IllegalArgumentException {
        super(bundleContext, 32, null);
        this.bundleContext = bundleContext;
        if (bundleContext == null) {
            throw new IllegalArgumentException("The BundleContext must not be null!");
        }
        if (xmlDirectory == null || xmlDirectory.isEmpty()) {
            throw new IllegalArgumentException("The XML directory must neither be null, nor empty!");
        }
        if (xmlDocumentTypeReader == null) {
            throw new IllegalArgumentException("The XmlDocumentTypeReader must not be null!");
        }
        if (xmlDocumentProviderFactory == null) {
            throw new IllegalArgumentException("The XmlDocumentProviderFactory must not be null!");
        }
        this.xmlDirectory = xmlDirectory;
        this.xmlDocumentTypeReader = xmlDocumentTypeReader;
        this.xmlDocumentProviderFactory = xmlDocumentProviderFactory;
        this.bundleDocumentProviderMap = new HashMap<Bundle, XmlDocumentProvider<T>>();
        this.asyncLoader = new AbstractAsyncBundleProcessor(){

            @Override
            protected boolean isBundleRelevant(Bundle bundle) {
                return this.isResourcePresent(bundle, XmlDocumentBundleTracker.this.xmlDirectory);
            }

            @Override
            protected void processBundle(Bundle bundle) {
                Enumeration xmlDocumentPaths = bundle.findEntries(XmlDocumentBundleTracker.this.xmlDirectory, "*.xml", true);
                if (xmlDocumentPaths != null) {
                    Collection<URL> filteredPaths = this.filterPatches(xmlDocumentPaths, bundle);
                    int numberOfParsedXmlDocuments = 0;
                    for (URL xmlDocumentURL : filteredPaths) {
                        String moduleName = bundle.getSymbolicName();
                        String xmlDocumentFile = xmlDocumentURL.getFile();
                        try {
                            XmlDocumentBundleTracker.this.logger.debug("Reading the XML document '{}' in module '{}'...", (Object)xmlDocumentFile, (Object)moduleName);
                            Object object = XmlDocumentBundleTracker.this.xmlDocumentTypeReader.readFromXML(xmlDocumentURL);
                            XmlDocumentBundleTracker.this.addingObject(bundle, object);
                            ++numberOfParsedXmlDocuments;
                        }
                        catch (Exception ex) {
                            XmlDocumentBundleTracker.this.logger.warn(String.format("The XML document '%s' in module '%s' could not be parsed: %s", xmlDocumentFile, moduleName, ex.getLocalizedMessage()), (Throwable)ex);
                        }
                    }
                    if (numberOfParsedXmlDocuments > 0) {
                        XmlDocumentBundleTracker.this.addingFinished(bundle);
                    }
                }
            }
        };
    }

    public final synchronized void open() {
        super.open();
        this.asyncLoaderRegistration = this.bundleContext.registerService(BundleProcessor.class.getName(), (Object)this.asyncLoader, null);
    }

    public final synchronized void close() {
        super.close();
        this.bundleDocumentProviderMap.clear();
        if (this.asyncLoaderRegistration != null) {
            this.asyncLoaderRegistration.unregister();
            this.asyncLoaderRegistration = null;
        }
    }

    private XmlDocumentProvider<T> acquireXmlDocumentProvider(Bundle bundle) {
        if (bundle != null) {
            XmlDocumentProvider<T> xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle);
            if (xmlDocumentProvider == null) {
                xmlDocumentProvider = this.xmlDocumentProviderFactory.createDocumentProvider(bundle);
                this.logger.debug("Create an empty XmlDocumentProvider for the module '{}'.", (Object)bundle.getSymbolicName());
                this.bundleDocumentProviderMap.put(bundle, xmlDocumentProvider);
            }
            return xmlDocumentProvider;
        }
        return null;
    }

    private void releaseXmlDocumentProvider(Bundle bundle) {
        XmlDocumentProvider<T> xmlDocumentProvider;
        if (bundle != null && (xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle)) != null) {
            try {
                this.logger.debug("Release the XmlDocumentProvider for the module '{}'.", (Object)bundle.getSymbolicName());
                xmlDocumentProvider.release();
            }
            catch (Exception ex) {
                this.logger.error("Could not release the XmlDocumentProvider for the module '" + bundle.getSymbolicName() + "'!", (Throwable)ex);
            }
            this.bundleDocumentProviderMap.remove(bundle);
        }
    }

    private void addingObject(Bundle bundle, T object) {
        XmlDocumentProvider<T> xmlDocumentProvider = this.acquireXmlDocumentProvider(bundle);
        if (xmlDocumentProvider != null) {
            xmlDocumentProvider.addingObject(object);
        }
    }

    private void addingFinished(Bundle bundle) {
        XmlDocumentProvider<T> xmlDocumentProvider = this.bundleDocumentProviderMap.get(bundle);
        if (xmlDocumentProvider != null) {
            try {
                xmlDocumentProvider.addingFinished();
            }
            catch (Exception ex) {
                this.logger.error("Could not send adding finished event for the module '" + bundle.getSymbolicName() + "'!", (Throwable)ex);
            }
        }
    }

    public final synchronized Bundle addingBundle(Bundle bundle, BundleEvent event) {
        this.asyncLoader.addingBundle(bundle);
        return bundle;
    }

    public final synchronized void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        this.logger.debug("Removing the XML related objects from module '{}'...", (Object)bundle.getSymbolicName());
        this.asyncLoader.removeBundle(bundle);
        this.releaseXmlDocumentProvider(bundle);
    }
}

