/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.hue.handler;

import nl.q42.jue.State;
import nl.q42.jue.StateUpdate;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.StringType;

public class LightStateConverter {
    private static final int HUE_FACTOR = 182;
    private static final double SATURATION_FACTOR = 2.54;
    private static final double BRIGHTNESS_FACTOR = 2.54;
    private static final int MIN_COLOR_TEMPERATURE = 153;
    private static final int MAX_COLOR_TEMPERATURE = 500;
    private static final int COLOR_TEMPERATURE_RANGE = 347;
    static final String ALERT_MODE_NONE = "NONE";
    static final String ALERT_MODE_SELECT = "SELECT";
    static final String ALERT_MODE_LONG_SELECT = "LSELECT";
    private static final int DIM_STEPSIZE = 30;

    public static StateUpdate toColorLightState(HSBType hsbType) {
        int hue = (int)Math.round(hsbType.getHue().doubleValue() * 182.0);
        int saturation = (int)Math.round(hsbType.getSaturation().doubleValue() * 2.54);
        int brightness = (int)Math.round(hsbType.getBrightness().doubleValue() * 2.54);
        StateUpdate stateUpdate = new StateUpdate().setHue(hue).setSat(saturation);
        if (brightness > 0) {
            stateUpdate.setBrightness(brightness);
        }
        return stateUpdate;
    }

    public static StateUpdate toOnOffLightState(OnOffType onOffType) {
        StateUpdate stateUpdate = new StateUpdate().setOn(OnOffType.ON.equals((Object)onOffType));
        return stateUpdate;
    }

    public static StateUpdate toBrightnessLightState(PercentType percentType) {
        boolean on = !percentType.equals((Object)PercentType.ZERO);
        StateUpdate stateUpdate = new StateUpdate().setOn(on);
        int brightness = (int)Math.round((double)percentType.floatValue() * 2.54);
        if (brightness > 0) {
            stateUpdate.setBrightness(brightness);
        }
        return stateUpdate;
    }

    public static int toAdjustedBrightness(IncreaseDecreaseType command, int currentBrightness) {
        int newBrightness = command == IncreaseDecreaseType.DECREASE ? Math.max(currentBrightness - 30, 0) : Math.min(currentBrightness + 30, 254);
        return newBrightness;
    }

    public static StateUpdate toColorTemperatureLightState(PercentType percentType) {
        int colorTemperature = 153 + Math.round(347.0f * percentType.floatValue() / 100.0f);
        StateUpdate stateUpdate = new StateUpdate().setColorTemperature(colorTemperature);
        return stateUpdate;
    }

    public static int toAdjustedColorTemp(IncreaseDecreaseType type, int currentColorTemp) {
        int newColorTemp = type == IncreaseDecreaseType.DECREASE ? Math.max(currentColorTemp - 30, 153) : Math.min(currentColorTemp + 30, 500);
        return newColorTemp;
    }

    public static PercentType toColorTemperaturePercentType(State lightState) {
        int percent = (int)Math.round((double)(lightState.getColorTemperature() - 153) * 100.0 / 347.0);
        return new PercentType(LightStateConverter.restrictToBounds(percent));
    }

    public static PercentType toBrightnessPercentType(State lightState) {
        int percent = (int)((double)lightState.getBrightness() / 2.54);
        return new PercentType(LightStateConverter.restrictToBounds(percent));
    }

    public static StringType toAlertStringType(State lightState) {
        return new StringType(lightState.getAlertMode().toString());
    }

    public static HSBType toHSBType(State lightState) {
        int hue = lightState.getHue();
        int saturationInPercent = (int)((double)lightState.getSaturation() / 2.54);
        int brightnessInPercent = (int)((double)lightState.getBrightness() / 2.54);
        saturationInPercent = LightStateConverter.restrictToBounds(saturationInPercent);
        brightnessInPercent = LightStateConverter.restrictToBounds(brightnessInPercent);
        HSBType hsbType = new HSBType(new DecimalType((long)(hue / 182)), new PercentType(saturationInPercent), new PercentType(brightnessInPercent));
        return hsbType;
    }

    public static StateUpdate toAlertState(StringType alertType) {
        State.AlertMode alertMode = null;
        switch (alertType.toString()) {
            case "NONE": {
                alertMode = State.AlertMode.NONE;
                break;
            }
            case "SELECT": {
                alertMode = State.AlertMode.SELECT;
                break;
            }
            case "LSELECT": {
                alertMode = State.AlertMode.LSELECT;
                break;
            }
            default: {
                return null;
            }
        }
        return new StateUpdate().setAlert(alertMode);
    }

    public static StateUpdate toOnOffEffectState(OnOffType onOffType) {
        StateUpdate stateUpdate = OnOffType.ON.equals((Object)onOffType) ? new StateUpdate().setEffect(State.Effect.COLORLOOP) : new StateUpdate().setEffect(State.Effect.NONE);
        return stateUpdate;
    }

    private static int restrictToBounds(int percentValue) {
        if (percentValue < 0) {
            return 0;
        }
        if (percentValue > 100) {
            return 100;
        }
        return percentValue;
    }
}

