/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.rest.internal;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.ResponseHeader;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.rest.internal.dto.EnrichedRuleDTO;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="rules")
@Api(value="rules")
public class RuleResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(RuleResource.class);
    private RuleRegistry ruleRegistry;
    @Context
    private UriInfo uriInfo;

    protected void setRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }

    protected void unsetRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available rules.", response=EnrichedRuleDTO.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll() {
        Collection<EnrichedRuleDTO> rules = this.enrich(this.ruleRegistry.getAll());
        return Response.ok(rules).build();
    }

    private Collection<EnrichedRuleDTO> enrich(Collection<Rule> rules) {
        ArrayList<EnrichedRuleDTO> enrichedRules = new ArrayList<EnrichedRuleDTO>(rules.size());
        for (Rule rule : rules) {
            enrichedRules.add(this.enrich(rule));
        }
        return enrichedRules;
    }

    private EnrichedRuleDTO enrich(Rule rule) {
        EnrichedRuleDTO enrichedRule = new EnrichedRuleDTO(rule);
        enrichedRule.enabled = this.ruleRegistry.isEnabled(rule.getUID());
        enrichedRule.status = this.ruleRegistry.getStatus(rule.getUID());
        return enrichedRule;
    }

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a rule.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", responseHeaders={@ResponseHeader(name="Location", description="Newly created Rule", response=String.class)}), @ApiResponse(code=409, message="Creation of the rule is refused. Rule with the same UID already exists."), @ApiResponse(code=400, message="Creation of the rule is refused. Missing required parameter.")})
    public Response create(@ApiParam(value="rule data", required=true) Rule rule) throws IOException {
        try {
            Rule newRule = (Rule)this.ruleRegistry.add((Object)rule);
            return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)("rules/" + URLEncoder.encode(newRule.getUID(), "UTF-8"))).build();
        }
        catch (IllegalArgumentException e) {
            String errMessage = "Creation of the rule is refused: " + e.getMessage();
            this.logger.warn(errMessage);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.CONFLICT, (String)errMessage);
        }
        catch (RuntimeException e) {
            String errMessage = "Creation of the rule is refused: " + e.getMessage();
            this.logger.warn(errMessage);
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.BAD_REQUEST, (String)errMessage);
        }
    }

    @GET
    @Path(value="/{ruleUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule corresponding to the given UID.", response=Rule.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule not found")})
    public Response getByUID(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)((Object)this.enrich(rule))).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="/{ruleUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Removes an existing rule corresponding to the given UID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response remove(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule removedRule = (Rule)this.ruleRegistry.remove((Object)ruleUID);
        if (removedRule == null) {
            this.logger.info("Received HTTP DELETE request at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{ruleUID}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates an existing rule corresponding to the given UID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response update(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @ApiParam(value="rule data", required=true) Rule rule) throws IOException {
        Rule oldRule = (Rule)this.ruleRegistry.update((Object)rule);
        if (oldRule == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{ruleUID}/config")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Gets the rule configuration values.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getConfiguration(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP GET request for config at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)rule.getConfiguration()).build();
    }

    @PUT
    @Path(value="/{ruleUID}/config")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Sets the rule configuration values.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response updateConfiguration(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @ApiParam(value="config") Map<String, Object> configurationParameters) throws IOException {
        Map config = ConfigUtil.normalizeTypes(configurationParameters);
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP PUT request for update config at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        rule.setConfiguration(config);
        this.ruleRegistry.update((Object)rule);
        return Response.ok().build();
    }

    @POST
    @Path(value="/{ruleUID}/enable")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Sets the rule enabled status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response enableRule(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @ApiParam(value="enable", required=true) String enabled) throws IOException {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule == null) {
            this.logger.info("Received HTTP PUT request for update config at '{}' for the unknown rule '{}'.", (Object)this.uriInfo.getPath(), (Object)ruleUID);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.ruleRegistry.setEnabled(ruleUID, !"false".equalsIgnoreCase(enabled));
        this.ruleRegistry.update((Object)rule);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{ruleUID}/triggers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule triggers.", response=Trigger.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getTriggers(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)rule.getTriggers()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule conditions.", response=Condition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getConditions(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)rule.getConditions()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/actions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule actions.", response=Action.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found.")})
    public Response getActions(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID) {
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null) {
            return Response.ok((Object)rule.getActions()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the rule's module corresponding to the given Category and ID.", response=Module.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleById(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            return Response.ok((Object)module).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the module's configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleConfig(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            return Response.ok((Object)module.getConfiguration()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config/{param}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Gets the module's configuration parameter.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    public Response getModuleConfigParam(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id, @PathParam(value="param") @ApiParam(value="param", required=true) String param) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            return Response.ok(module.getConfiguration().get(param)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @PUT
    @Path(value="/{ruleUID}/{moduleCategory}/{id}/config/{param}")
    @ApiOperation(value="Sets the module's configuration parameter value.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Rule corresponding to the given UID does not found or does not have a module with such Category and ID.")})
    @Consumes(value={"text/plain"})
    public Response setModuleConfigParam(@PathParam(value="ruleUID") @ApiParam(value="ruleUID", required=true) String ruleUID, @PathParam(value="moduleCategory") @ApiParam(value="moduleCategory", required=true) String moduleCategory, @PathParam(value="id") @ApiParam(value="id", required=true) String id, @PathParam(value="param") @ApiParam(value="param", required=true) String param, @ApiParam(value="value", required=true) String value) {
        Module module;
        Rule rule = (Rule)this.ruleRegistry.get((Object)ruleUID);
        if (rule != null && (module = this.getModule(rule, moduleCategory, id)) != null) {
            Map configuration = module.getConfiguration();
            configuration.put(param, ConfigUtil.normalizeType((Object)value));
            module.setConfiguration(configuration);
            this.ruleRegistry.update((Object)rule);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected Trigger getTrigger(Rule rule, String id) {
        for (Trigger trigger : rule.getTriggers()) {
            if (!trigger.getId().equals(id)) continue;
            return trigger;
        }
        return null;
    }

    protected Condition getCondition(Rule rule, String id) {
        for (Condition condition : rule.getConditions()) {
            if (!condition.getId().equals(id)) continue;
            return condition;
        }
        return null;
    }

    protected Action getAction(Rule rule, String id) {
        for (Action action : rule.getActions()) {
            if (!action.getId().equals(id)) continue;
            return action;
        }
        return null;
    }

    protected Module getModule(Rule rule, String moduleCategory, String id) {
        Trigger module = null;
        if (moduleCategory.equals("triggers")) {
            module = this.getTrigger(rule, id);
        } else if (moduleCategory.equals("conditions")) {
            module = this.getCondition(rule, id);
        } else if (moduleCategory.equals("actions")) {
            module = this.getAction(rule, id);
        }
        return module;
    }
}

