/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.Hashtable;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleProvider;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.core.internal.ManagedRuleProvider;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.core.internal.RuleRegistryImpl;
import org.eclipse.smarthome.automation.core.internal.composite.CompositeModuleHandlerFactory;
import org.eclipse.smarthome.automation.core.internal.template.TemplateManager;
import org.eclipse.smarthome.automation.core.internal.template.TemplateRegistryImpl;
import org.eclipse.smarthome.automation.core.internal.type.ModuleTypeManager;
import org.eclipse.smarthome.automation.core.internal.type.ModuleTypeRegistryImpl;
import org.eclipse.smarthome.automation.core.util.ConnectionValidator;
import org.eclipse.smarthome.automation.events.RuleEventFactory;
import org.eclipse.smarthome.automation.template.TemplateRegistry;
import org.eclipse.smarthome.automation.type.ModuleTypeRegistry;
import org.eclipse.smarthome.core.common.registry.ManagedProvider;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.storage.Storage;
import org.eclipse.smarthome.core.storage.StorageService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private ModuleTypeRegistryImpl moduleTypeRegistry;
    private TemplateRegistryImpl templateRegistry;
    private RuleEventFactory ruleEventFactory;
    private ModuleTypeManager mtManager;
    private TemplateManager tManager;
    private ServiceRegistration ruleRegistryReg;
    private RuleRegistryImpl ruleRegistry;
    private ServiceRegistration managedRuleProviderReg;
    private ServiceRegistration templateRegistryReg;
    private ServiceRegistration moduleTypeRegistryReg;
    private ServiceRegistration ruleEventFactoryReg;
    private ServiceTracker serviceTracker;
    private ServiceRegistration<?> configReg;
    private RuleEngine ruleEngine;

    public void start(final BundleContext bc) throws Exception {
        this.ruleEngine = new RuleEngine(bc);
        Hashtable<String, String> props = new Hashtable<String, String>(11);
        props.put("service.pid", "smarthome.rule.configuration");
        this.configReg = bc.registerService(ManagedService.class.getName(), (Object)this.ruleEngine, props);
        this.tManager = new TemplateManager(bc, this.ruleEngine);
        this.ruleEngine.setTemplateManager(this.tManager);
        this.mtManager = new ModuleTypeManager(bc, this.ruleEngine);
        this.ruleEngine.setModuleTypeManager(this.mtManager);
        this.ruleEngine.setCompositeModuleFactory(new CompositeModuleHandlerFactory(bc, this.mtManager, this.ruleEngine));
        ConnectionValidator.setManager(this.mtManager);
        this.templateRegistry = new TemplateRegistryImpl(this.tManager);
        this.templateRegistryReg = bc.registerService(TemplateRegistry.class.getName(), (Object)this.templateRegistry, null);
        this.moduleTypeRegistry = new ModuleTypeRegistryImpl(this.mtManager);
        this.moduleTypeRegistryReg = bc.registerService(ModuleTypeRegistry.class.getName(), (Object)this.moduleTypeRegistry, null);
        this.ruleEventFactory = new RuleEventFactory();
        this.ruleEventFactoryReg = bc.registerService(EventFactory.class.getName(), (Object)this.ruleEventFactory, null);
        this.ruleRegistry = new RuleRegistryImpl(this.ruleEngine);
        Filter filter = bc.createFilter("(|(objectClass=" + StorageService.class.getName() + ")(" + "objectClass" + "=" + RuleProvider.class.getName() + ")(" + "objectClass" + "=" + EventPublisher.class.getName() + "))");
        this.serviceTracker = new ServiceTracker(bc, filter, new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                Object service = bc.getService(reference);
                if (service instanceof StorageService) {
                    StorageService storage = (StorageService)service;
                    if (storage != null) {
                        Storage storageDisabledRules = storage.getStorage("automation_rules_disabled", this.getClass().getClassLoader());
                        Activator.this.ruleRegistry.setDisabledRuleStorage((Storage<Boolean>)storageDisabledRules);
                        ManagedRuleProvider managedRuleProvider = new ManagedRuleProvider(storage);
                        Activator.this.ruleEngine.setManagedRuleProvider(managedRuleProvider);
                        Activator.this.ruleRegistry.setManagedProvider((ManagedProvider<Rule, String>)managedRuleProvider);
                        Activator.this.managedRuleProviderReg = bc.registerService(RuleProvider.class.getName(), (Object)managedRuleProvider, null);
                        return storage;
                    }
                } else {
                    if (service instanceof RuleProvider) {
                        RuleProvider rp = (RuleProvider)service;
                        Activator.this.ruleRegistry.addProvider((Provider<Rule>)rp);
                        if (rp instanceof ManagedRuleProvider) {
                            Activator.this.ruleRegistryReg = bc.registerService(RuleRegistry.class.getName(), (Object)Activator.this.ruleRegistry, null);
                        }
                        return rp;
                    }
                    if (service instanceof EventPublisher) {
                        EventPublisher ep = (EventPublisher)service;
                        Activator.this.ruleRegistry.setEventPublisher(ep);
                        return ep;
                    }
                }
                return null;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                if (service instanceof StorageService) {
                    if (Activator.this.managedRuleProviderReg != null) {
                        Activator.this.managedRuleProviderReg.unregister();
                        Activator.this.managedRuleProviderReg = null;
                    }
                } else if (service instanceof EventPublisher) {
                    if (Activator.this.ruleRegistry != null) {
                        Activator.this.ruleRegistry.unsetEventPublisher((EventPublisher)service);
                    }
                } else if (service instanceof RuleProvider && Activator.this.ruleRegistry != null) {
                    RuleProvider rp = (RuleProvider)service;
                    if (rp instanceof ManagedRuleProvider) {
                        Activator.this.ruleRegistry.removeManagedProvider((ManagedProvider<Rule, String>)((ManagedProvider)rp));
                    } else {
                        Activator.this.ruleRegistry.removeProvider((Provider<Rule>)rp);
                    }
                }
            }
        });
        this.serviceTracker.open();
    }

    public void stop(BundleContext bc) throws Exception {
        this.serviceTracker.close();
        this.serviceTracker = null;
        if (this.configReg != null) {
            this.configReg.unregister();
            this.configReg = null;
        }
        if (this.ruleRegistryReg != null) {
            this.ruleRegistryReg.unregister();
            this.ruleRegistryReg = null;
            this.ruleRegistry.dispose();
            this.ruleRegistry = null;
        }
        if (this.templateRegistryReg != null) {
            this.templateRegistryReg.unregister();
            this.templateRegistryReg = null;
            this.templateRegistry.dispose();
            this.templateRegistry = null;
        }
        if (this.moduleTypeRegistryReg != null) {
            this.moduleTypeRegistryReg.unregister();
            this.moduleTypeRegistryReg = null;
            this.moduleTypeRegistry.dispose();
            this.moduleTypeRegistry = null;
        }
        if (this.ruleEventFactoryReg != null) {
            this.ruleEventFactoryReg.unregister();
            this.ruleEventFactory = null;
            this.ruleEventFactoryReg = null;
        }
        this.ruleEngine.dispose();
    }
}

