/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class Connection {
    public static final String REF_IDENTIFIER = "$";
    private String ouputModuleId;
    private String outputName;
    private String inputName;

    public Connection(String inputName, String ouputModuleId, String outputName) {
        this.validate("inputName", inputName);
        this.validate("outputName", outputName);
        this.inputName = inputName;
        this.ouputModuleId = ouputModuleId;
        this.outputName = outputName;
    }

    public String getOuputModuleId() {
        return this.ouputModuleId;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getInputName() {
        return this.inputName;
    }

    public boolean equals(Object obj) {
        return this.inputName != null && obj instanceof Connection && this.inputName.equals(((Connection)obj).getInputName());
    }

    public int hashCode() {
        return this.inputName.hashCode();
    }

    private void validate(String field, String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid identifier for " + field);
        }
    }

    public String toString() {
        return "Connection " + this.ouputModuleId + "." + this.outputName + "->" + this.inputName;
    }

    public static Set<Connection> getConnections(Map<String, String> inputs, Logger log) {
        HashSet<Connection> connections = new HashSet<Connection>(11);
        if (inputs != null) {
            for (Map.Entry<String, String> input : inputs.entrySet()) {
                String inputName = input.getKey();
                String outputName = null;
                String output = input.getValue();
                if (output.startsWith(REF_IDENTIFIER)) {
                    outputName = output;
                    Connection connection = new Connection(inputName, null, outputName);
                    connections.add(connection);
                    continue;
                }
                int index = output.indexOf(46);
                if (index != -1) {
                    String outputId = output.substring(0, index);
                    outputName = output.substring(index + 1);
                    Connection connection = new Connection(inputName, outputId, outputName);
                    connections.add(connection);
                    continue;
                }
                log.error("Wrong format of Output : " + inputName + ": " + output);
            }
        }
        return connections;
    }
}

