/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceResolverUtil {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceResolverUtil.class);

    private ReferenceResolverUtil() {
    }

    public static void updateModuleConfiguration(Module module, Map<String, ?> context) {
        for (Map.Entry entry : module.getConfiguration().entrySet()) {
            Object result;
            Object o = entry.getValue();
            if (!(o instanceof String)) continue;
            String childConfigPropertyValue = (String)o;
            if (ReferenceResolverUtil.isReference(childConfigPropertyValue)) {
                result = ReferenceResolverUtil.resolveReference(childConfigPropertyValue, context);
                if (result == null) continue;
                entry.setValue(result);
                continue;
            }
            if (!ReferenceResolverUtil.isPattern(childConfigPropertyValue)) continue;
            result = ReferenceResolverUtil.resolvePattern(childConfigPropertyValue, context);
            entry.setValue(result);
        }
    }

    public static Map<String, Object> getCompositeChildContext(Module module, Map<String, ?> compositeContext) {
        HashMap<String, Object> resultContext = new HashMap<String, Object>();
        Map inputs = null;
        if (module instanceof Condition) {
            inputs = ((Condition)module).getInputs();
        } else if (module instanceof Action) {
            inputs = ((Action)module).getInputs();
        }
        if (inputs != null) {
            for (Map.Entry input : inputs.entrySet()) {
                String inputName = (String)input.getKey();
                String inputValue = (String)input.getValue();
                if (!ReferenceResolverUtil.isReference(inputValue)) continue;
                Object result = ReferenceResolverUtil.resolveReference(inputValue, compositeContext);
                resultContext.put(inputName, result);
            }
        }
        return resultContext;
    }

    public static Object resolveReference(String reference, Map<String, ?> context) {
        String result = reference;
        if (ReferenceResolverUtil.isReference(reference)) {
            result = context.get(reference.trim().substring(1));
        }
        return result;
    }

    private static String resolvePattern(String reference, Map<String, ?> context) {
        int start;
        StringBuilder sb = new StringBuilder();
        int previous = 0;
        while ((start = reference.indexOf("${", previous)) != -1) {
            sb.append(reference.substring(previous, start));
            int end = reference.indexOf(125, start + 2);
            if (end == -1) {
                previous = start;
                logger.warn("Couldn't parse referenced key: " + reference.substring(start) + ": expected reference syntax-> ${referencedKey}");
                break;
            }
            String referencedKey = reference.substring(start + 2, end);
            Object referencedValue = context.get(referencedKey);
            if (referencedValue != null) {
                if (ReferenceResolverUtil.isSupportedPatternReferenceType(referencedValue)) {
                    sb.append(referencedValue);
                } else {
                    sb.append(reference.substring(start, end + 1));
                    logger.warn("Not supported type: " + referencedValue.getClass());
                }
            } else {
                sb.append(reference.substring(start, end + 1));
                logger.warn("Cannot find reference for ${ {} } , it will remain the same.", (Object)referencedKey);
            }
            previous = end + 1;
        }
        sb.append(reference.substring(previous));
        return sb.toString();
    }

    private static boolean isSupportedPatternReferenceType(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean;
    }

    private static boolean isReference(Object value) {
        boolean result = false;
        if (value instanceof String) {
            String strVal = ((String)value).trim();
            result = strVal.startsWith("$") && strVal.lastIndexOf("$") == 0 && strVal.length() > 1 && strVal.charAt(1) != '{';
        }
        return result;
    }

    private static boolean isPattern(String value) {
        return value != null && value.trim().contains("${") && value.trim().contains("}");
    }
}

