/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.core.internal.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.core.internal.RuleEngine;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.CompositeActionType;
import org.eclipse.smarthome.automation.type.CompositeConditionType;
import org.eclipse.smarthome.automation.type.CompositeTriggerType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.ModuleTypeProvider;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ModuleTypeManager
implements ServiceTrackerCustomizer {
    private ServiceTracker moduleTypeTracker;
    private RuleEngine ruleEngine;
    private Set<ModuleTypeProvider> providers = new HashSet<ModuleTypeProvider>();
    private BundleContext bc;

    public ModuleTypeManager(BundleContext bc, RuleEngine re) {
        this.bc = bc;
        this.ruleEngine = re;
        this.moduleTypeTracker = new ServiceTracker(bc, ModuleTypeProvider.class.getName(), (ServiceTrackerCustomizer)this);
        this.moduleTypeTracker.open();
    }

    public <T extends ModuleType> T get(String typeUID) {
        return this.get(typeUID, null);
    }

    public <T extends ModuleType> T get(String typeUID, Locale locale) {
        ModuleType mType = null;
        for (ModuleTypeProvider provider : this.providers) {
            mType = provider.getModuleType(typeUID, locale);
            if (mType == null) continue;
            return (T)this.createCopy(mType);
        }
        return null;
    }

    public <T extends ModuleType> Collection<T> getByTag(String tag) {
        return this.getByTag(tag, null);
    }

    public <T extends ModuleType> Collection<T> getByTag(String tag, Locale locale) {
        ArrayList<ModuleType> result = new ArrayList<ModuleType>(20);
        Collection moduleTypes = null;
        for (ModuleTypeProvider provider : this.providers) {
            moduleTypes = provider.getModuleTypes(locale);
            if (moduleTypes == null) continue;
            for (ModuleType mt : moduleTypes) {
                if (tag != null) {
                    Set tags = mt.getTags();
                    if (tags == null || !tags.contains(tag)) continue;
                    result.add(this.createCopy(mt));
                    continue;
                }
                result.add(this.createCopy(mt));
            }
        }
        return result;
    }

    public <T extends ModuleType> Collection<T> getTypesByTags(Set<String> tags) {
        return this.getByTags(tags, null);
    }

    public <T extends ModuleType> Collection<T> getByTags(Set<String> tags, Locale locale) {
        ArrayList<ModuleType> result = new ArrayList<ModuleType>(20);
        Collection moduleTypes = null;
        for (ModuleTypeProvider provider : this.providers) {
            moduleTypes = provider.getModuleTypes(locale);
            if (moduleTypes == null) continue;
            for (ModuleType mt : moduleTypes) {
                if (tags != null) {
                    Set mtTags = mt.getTags();
                    if (!mtTags.containsAll(tags)) continue;
                    result.add(this.createCopy(mt));
                    continue;
                }
                result.add(this.createCopy(mt));
            }
        }
        return result;
    }

    public <T extends ModuleType> Collection<T> getAll(Class<T> classModuleType) {
        return this.getAll(classModuleType, null);
    }

    public <T extends ModuleType> Collection<T> getAll(Class<T> moduleType, Locale locale) {
        ArrayList<ModuleType> result = new ArrayList<ModuleType>(20);
        Collection moduleTypes = null;
        for (ModuleTypeProvider provider : this.providers) {
            moduleTypes = provider.getModuleTypes(locale);
            if (moduleTypes == null) continue;
            for (ModuleType mt : moduleTypes) {
                if (moduleType != null) {
                    if (!moduleType.isInstance(mt)) continue;
                    result.add(this.createCopy(mt));
                    continue;
                }
                result.add(this.createCopy(mt));
            }
        }
        return result;
    }

    public void dispose() {
        if (this.moduleTypeTracker != null) {
            this.moduleTypeTracker.close();
            this.moduleTypeTracker = null;
        }
        this.providers.clear();
    }

    private ModuleType createCopy(ModuleType mType) {
        CompositeTriggerType result;
        if (mType == null) {
            return null;
        }
        if (mType instanceof CompositeTriggerType) {
            CompositeTriggerType m = (CompositeTriggerType)mType;
            result = new CompositeTriggerType(mType.getUID(), mType.getConfigurationDescription(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getOutputs(), ModuleTypeManager.copyTriggers(m.getChildren()));
        } else if (mType instanceof TriggerType) {
            TriggerType m = (TriggerType)mType;
            result = new TriggerType(mType.getUID(), mType.getConfigurationDescription(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getOutputs());
        } else if (mType instanceof CompositeConditionType) {
            CompositeConditionType m = (CompositeConditionType)mType;
            result = new CompositeConditionType(mType.getUID(), mType.getConfigurationDescription(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), ModuleTypeManager.copyConditions(m.getChildren()));
        } else if (mType instanceof ConditionType) {
            ConditionType m = (ConditionType)mType;
            result = new ConditionType(mType.getUID(), mType.getConfigurationDescription(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs());
        } else if (mType instanceof CompositeActionType) {
            CompositeActionType m = (CompositeActionType)mType;
            result = new CompositeActionType(mType.getUID(), mType.getConfigurationDescription(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), m.getOutputs(), ModuleTypeManager.copyActions(m.getChildren()));
        } else if (mType instanceof ActionType) {
            ActionType m = (ActionType)mType;
            result = new ActionType(mType.getUID(), mType.getConfigurationDescription(), mType.getLabel(), mType.getDescription(), mType.getTags(), mType.getVisibility(), m.getInputs(), m.getOutputs());
        } else {
            throw new IllegalArgumentException("Invalid template type:" + mType);
        }
        return result;
    }

    private static List<Trigger> copyTriggers(List<Trigger> triggers) {
        ArrayList<Trigger> res = new ArrayList<Trigger>(11);
        if (triggers != null) {
            for (Trigger t : triggers) {
                Trigger trigger = new Trigger(t.getId(), t.getTypeUID(), t.getConfiguration());
                trigger.setLabel(trigger.getLabel());
                trigger.setDescription(trigger.getDescription());
                res.add(trigger);
            }
        }
        return res;
    }

    private static List<Condition> copyConditions(List<Condition> conditions) {
        ArrayList<Condition> res = new ArrayList<Condition>(11);
        if (conditions != null) {
            for (Condition c : conditions) {
                Condition condition = new Condition(c.getId(), c.getTypeUID(), c.getConfiguration(), c.getInputs());
                condition.setLabel(condition.getLabel());
                condition.setDescription(condition.getDescription());
                res.add(condition);
            }
        }
        return res;
    }

    private static List<Action> copyActions(List<Action> actions) {
        ArrayList<Action> res = new ArrayList<Action>();
        if (actions != null) {
            for (Action a : actions) {
                Action action = new Action(a.getId(), a.getTypeUID(), a.getConfiguration(), a.getInputs());
                action.setLabel(a.getLabel());
                action.setDescription(a.getDescription());
                res.add(action);
            }
        }
        return res;
    }

    public Object addingService(ServiceReference reference) {
        ModuleTypeProvider provider = (ModuleTypeProvider)this.bc.getService(reference);
        if (provider != null) {
            this.providers.add(provider);
            this.ruleEngine.moduleTypeUpdated(provider.getModuleTypes(null));
        }
        return provider;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        ModuleTypeProvider provider = (ModuleTypeProvider)this.bc.getService(reference);
        if (provider != null) {
            this.ruleEngine.moduleTypeUpdated(provider.getModuleTypes(null));
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        this.providers.remove(service);
    }
}

