/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.timer.handler;

import java.util.UUID;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.RuleEngineCallback;
import org.eclipse.smarthome.automation.handler.TriggerHandler;
import org.eclipse.smarthome.automation.module.timer.handler.CallbackJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerTriggerHandler
extends BaseModuleHandler<Trigger>
implements TriggerHandler {
    private final Logger logger = LoggerFactory.getLogger(TimerTriggerHandler.class);
    private RuleEngineCallback callback;
    private JobDetail job;
    private CronTrigger trigger;
    private Scheduler scheduler;
    public static final String MODULE_TYPE_ID = "TimerTrigger";
    public static final String CALLBACK_CONTEXT_NAME = "CALLBACK";
    public static final String MODULE_CONTEXT_NAME = "MODULE";
    private static final String CFG_CRON_EXPRESSION = "cronExpression";

    public TimerTriggerHandler(Trigger module) {
        super((Module)module);
        String cronExpression = (String)module.getConfiguration().get(CFG_CRON_EXPRESSION);
        this.trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(MODULE_TYPE_ID + UUID.randomUUID().toString()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
    }

    public void setRuleEngineCallback(RuleEngineCallback ruleCallback) {
        this.callback = ruleCallback;
        this.job = JobBuilder.newJob(CallbackJob.class).withIdentity(MODULE_TYPE_ID + UUID.randomUUID().toString()).build();
        this.job.getJobDataMap().put(CALLBACK_CONTEXT_NAME, (Object)this.callback);
        this.job.getJobDataMap().put(MODULE_CONTEXT_NAME, (Object)this.module);
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
            this.scheduler.start();
            this.scheduler.scheduleJob(this.job, (org.quartz.Trigger)this.trigger);
        }
        catch (SchedulerException e) {
            this.logger.error("Error while scheduling Job: {}", (Object)e.getMessage());
        }
    }

    public void dispose() {
        try {
            if (this.scheduler != null && this.job != null) {
                this.scheduler.deleteJob(this.job.getKey());
            }
            this.scheduler = null;
            this.trigger = null;
            this.job = null;
        }
        catch (SchedulerException e) {
            this.logger.error("Error while disposing Job: {}", (Object)e.getMessage());
        }
    }
}

