/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.binding.xml.internal;

import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.XmlConfigDescriptionProvider;
import org.eclipse.smarthome.config.xml.osgi.XmlDocumentProvider;
import org.eclipse.smarthome.core.binding.BindingInfo;
import org.eclipse.smarthome.core.binding.xml.internal.BindingInfoXmlResult;
import org.eclipse.smarthome.core.binding.xml.internal.XmlBindingInfoProvider;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingInfoXmlProvider
implements XmlDocumentProvider<BindingInfoXmlResult> {
    private Logger logger = LoggerFactory.getLogger(BindingInfoXmlProvider.class);
    private Bundle bundle;
    private XmlBindingInfoProvider bindingInfoProvider;
    private XmlConfigDescriptionProvider configDescriptionProvider;

    public BindingInfoXmlProvider(Bundle bundle, XmlBindingInfoProvider bindingInfoProvider, XmlConfigDescriptionProvider configDescriptionProvider) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("The Bundle must not be null!");
        }
        if (bindingInfoProvider == null) {
            throw new IllegalArgumentException("The XmlBindingInfoProvider must not be null!");
        }
        if (configDescriptionProvider == null) {
            throw new IllegalArgumentException("The XmlConfigDescriptionProvider must not be null!");
        }
        this.bundle = bundle;
        this.bindingInfoProvider = bindingInfoProvider;
        this.configDescriptionProvider = configDescriptionProvider;
    }

    public synchronized void addingObject(BindingInfoXmlResult bindingInfoXmlResult) {
        if (bindingInfoXmlResult != null) {
            ConfigDescription configDescription = bindingInfoXmlResult.getConfigDescription();
            if (configDescription != null) {
                try {
                    this.configDescriptionProvider.addConfigDescription(this.bundle, configDescription);
                }
                catch (Exception ex) {
                    this.logger.error("Could not register ConfigDescription!", (Throwable)ex);
                }
            }
            BindingInfo bindingInfo = bindingInfoXmlResult.getBindingInfo();
            this.bindingInfoProvider.addBindingInfo(this.bundle, bindingInfo);
        }
    }

    public void addingFinished() {
    }

    public synchronized void release() {
        this.bindingInfoProvider.removeAllBindingInfos(this.bundle);
        this.configDescriptionProvider.removeAllConfigDescriptions(this.bundle);
    }
}

