/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal.handler;

import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.handler.ConditionHandler;
import org.eclipse.smarthome.automation.module.script.internal.ScriptModuleActivator;
import org.eclipse.smarthome.automation.module.script.internal.handler.AbstractScriptModuleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptConditionHandler
extends AbstractScriptModuleHandler<Condition>
implements ConditionHandler {
    public final Logger logger = LoggerFactory.getLogger(ScriptConditionHandler.class);
    public static final String SCRIPT_CONDITION = "ScriptCondition";

    public ScriptConditionHandler(Condition module) {
        super(module);
    }

    public boolean isSatisfied(Map<String, ?> context) {
        Object type = ((Condition)this.module).getConfiguration().get("type");
        Object script = ((Condition)this.module).getConfiguration().get("script");
        if (type instanceof String) {
            if (script instanceof String) {
                ScriptEngine engine = ScriptModuleActivator.getScriptEngine((String)type);
                if (engine != null) {
                    ScriptContext executionContext = this.getExecutionContext(engine, context);
                    try {
                        Object returnVal = engine.eval((String)script, executionContext);
                        if (returnVal instanceof Boolean) {
                            return (Boolean)returnVal;
                        }
                        this.logger.error("Script did not return a boolean value, but '{}'", (Object)returnVal.toString());
                    }
                    catch (ScriptException e) {
                        this.logger.error("Script execution failed: {}", (Object)e.getMessage());
                    }
                } else {
                    this.logger.debug("No engine available for script type '{}' in condition '{}'.", new Object[]{type, ((Condition)this.module).getId()});
                }
            } else {
                this.logger.debug("Script is missing in the configuration of condition '{}'.", (Object)((Condition)this.module).getId());
            }
        } else {
            this.logger.debug("Script type is missing in the configuration of action '{}'.", (Object)((Condition)this.module).getId());
        }
        return true;
    }
}

