/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.config.discovery;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.internal.DiscoveryResultImpl;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;

public class DiscoveryResultBuilder {
    private final ThingUID thingUID;
    private ThingUID bridgeUID;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String representationProperty;
    private String label;
    private long ttl = -1L;
    private ThingTypeUID thingTypeUID;

    private DiscoveryResultBuilder(ThingUID thingUID) {
        this.thingTypeUID = thingUID.getThingTypeUID();
        this.thingUID = thingUID;
    }

    public static DiscoveryResultBuilder create(ThingUID thingUID) {
        return new DiscoveryResultBuilder(thingUID);
    }

    public DiscoveryResultBuilder withThingType(ThingTypeUID thingTypeUID) {
        this.thingTypeUID = thingTypeUID;
        return this;
    }

    public DiscoveryResultBuilder withProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public DiscoveryResultBuilder withProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public DiscoveryResultBuilder withRepresentationProperty(String representationProperty) {
        this.representationProperty = representationProperty;
        return this;
    }

    public DiscoveryResultBuilder withBridge(ThingUID bridgeUID) {
        this.bridgeUID = bridgeUID;
        return this;
    }

    public DiscoveryResultBuilder withLabel(String label) {
        this.label = label;
        return this;
    }

    public DiscoveryResultBuilder withTTL(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public DiscoveryResult build() {
        return new DiscoveryResultImpl(this.thingTypeUID, this.thingUID, this.bridgeUID, this.properties, this.representationProperty, this.label, this.ttl);
    }
}

