/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.channel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTO;
import org.eclipse.smarthome.config.core.dto.ConfigDescriptionDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ChannelTypeDTO;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;

@Path(value="channel-types")
@Api(value="channel-types")
public class ChannelTypeResource
implements RESTResource {
    public static final String PATH_CHANNEL_TYPES = "channel-types";
    private ChannelTypeRegistry channelTypeRegistry;
    private ConfigDescriptionRegistry configDescriptionRegistry;

    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available channel types.", response=ChannelTypeDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Set<ChannelTypeDTO> channelTypeDTOs = this.convertToChannelTypeDTOs(this.channelTypeRegistry.getChannelTypes(locale), locale);
        return Response.ok(channelTypeDTOs).build();
    }

    @GET
    @Path(value="/{channelTypeUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets channel type by UID.", response=ChannelTypeDTO.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Channel type with provided channelTypeUID does not exist."), @ApiResponse(code=404, message="No content")})
    public Response getByUID(@PathParam(value="channelTypeUID") @ApiParam(value="channelTypeUID") String channelTypeUID, @HeaderParam(value="Accept-Language") @ApiParam(value="Accept-Language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        ChannelType channelType = this.channelTypeRegistry.getChannelType(new ChannelTypeUID(channelTypeUID), locale);
        if (channelType != null) {
            return Response.ok((Object)this.convertToChannelTypeDTO(channelType, locale)).build();
        }
        return Response.noContent().build();
    }

    public Set<ChannelTypeDTO> getChannelTypeDTOs(Locale locale) {
        List channelTypes = this.channelTypeRegistry.getChannelTypes();
        Set<ChannelTypeDTO> channelTypeDTOs = this.convertToChannelTypeDTOs(channelTypes, locale);
        return channelTypeDTOs;
    }

    private ChannelTypeDTO convertToChannelTypeDTO(ChannelType channelType, Locale locale) {
        ArrayList parameterGroups;
        List parameters;
        ConfigDescription configDescription = channelType.hasConfigDescriptionURI() ? this.configDescriptionRegistry.getConfigDescription(channelType.getConfigDescriptionURI(), locale) : null;
        if (configDescription != null) {
            ConfigDescriptionDTO configDescriptionDTO = ConfigDescriptionDTOMapper.map(configDescription);
            parameters = configDescriptionDTO.parameters;
            parameterGroups = configDescriptionDTO.parameterGroups;
        } else {
            parameters = new ArrayList(0);
            parameterGroups = new ArrayList(0);
        }
        return new ChannelTypeDTO(channelType.getUID().toString(), channelType.getLabel(), channelType.getDescription(), channelType.getCategory(), channelType.getItemType(), parameters, parameterGroups, channelType.getState(), channelType.getTags());
    }

    private Set<ChannelTypeDTO> convertToChannelTypeDTOs(List<ChannelType> channelTypes, Locale locale) {
        HashSet<ChannelTypeDTO> channelTypeDTOs = new HashSet<ChannelTypeDTO>();
        for (ChannelType channelType : channelTypes) {
            channelTypeDTOs.add(this.convertToChannelTypeDTO(channelType, locale));
        }
        return channelTypeDTOs;
    }
}

