/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.discovery;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultFlag;
import org.eclipse.smarthome.config.discovery.dto.DiscoveryResultDTO;
import org.eclipse.smarthome.config.discovery.dto.DiscoveryResultDTOMapper;
import org.eclipse.smarthome.config.discovery.inbox.Inbox;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.RESTResource;

@Path(value="inbox")
@Api(value="inbox")
public class InboxResource
implements RESTResource {
    public static final String PATH_INBOX = "inbox";
    private Inbox inbox;
    @Context
    private UriInfo uriInfo;

    protected void setInbox(Inbox inbox) {
        this.inbox = inbox;
    }

    protected void unsetInbox(Inbox inbox) {
        this.inbox = null;
    }

    @POST
    @Path(value="/{thingUID}/approve")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Approves the discovery result by adding the thing to the registry.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Thing not found in the inbox."), @ApiResponse(code=409, message="No binding found that supports this thing.")})
    public Response approve(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thingUID", required=true) String thingUID, @ApiParam(value="thing label") String label) {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        String notEmptyLabel = label != null && !label.isEmpty() ? label : null;
        Thing thing = null;
        try {
            thing = this.inbox.approve(thingUIDObject, notEmptyLabel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.NOT_FOUND, (String)"Thing not found in inbox");
        }
        if (thing == null) {
            return JSONResponse.createErrorResponse((Response.Status)Response.Status.CONFLICT, (String)"No binding found that can create the thing");
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{thingUID}")
    @ApiOperation(value="Removes the discovery result from the inbox.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Discovery result not found in the inbox.")})
    public Response delete(@PathParam(value="thingUID") @ApiParam(value="thingUID", required=true) String thingUID) {
        if (this.inbox.remove(new ThingUID(thingUID))) {
            return Response.ok().build();
        }
        return JSONResponse.createErrorResponse((Response.Status)Response.Status.NOT_FOUND, (String)"Thing not found in inbox");
    }

    @GET
    @Produces(value={"*/*"})
    @ApiOperation(value="Get all discovered things.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll() {
        List discoveryResults = this.inbox.getAll();
        Set<DiscoveryResultDTO> discoveryResultBeans = this.convertToListBean(discoveryResults);
        return Response.ok(discoveryResultBeans).build();
    }

    @POST
    @Path(value="/{thingUID}/ignore")
    @ApiOperation(value="Flags a discovery result as ignored for further processing.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response ignore(@PathParam(value="thingUID") @ApiParam(value="thingUID", required=true) String thingUID) {
        this.inbox.setFlag(new ThingUID(thingUID), DiscoveryResultFlag.IGNORED);
        return Response.ok().build();
    }

    @POST
    @Path(value="/{thingUID}/unignore")
    @ApiOperation(value="Removes ignore flag from a discovery result.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response unignore(@PathParam(value="thingUID") @ApiParam(value="thingUID", required=true) String thingUID) {
        this.inbox.setFlag(new ThingUID(thingUID), DiscoveryResultFlag.NEW);
        return Response.ok().build();
    }

    private Set<DiscoveryResultDTO> convertToListBean(List<DiscoveryResult> discoveryResults) {
        LinkedHashSet<DiscoveryResultDTO> discoveryResultBeans = new LinkedHashSet<DiscoveryResultDTO>();
        for (DiscoveryResult discoveryResult : discoveryResults) {
            discoveryResultBeans.add(DiscoveryResultDTOMapper.map((DiscoveryResult)discoveryResult));
        }
        return discoveryResultBeans;
    }
}

