/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.item;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.dto.ItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTOMapper;
import org.eclipse.smarthome.core.transform.TransformationHelper;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.io.rest.core.internal.RESTCoreActivator;
import org.eclipse.smarthome.io.rest.core.item.EnrichedGroupItemDTO;
import org.eclipse.smarthome.io.rest.core.item.EnrichedItemDTO;
import org.osgi.framework.BundleContext;

public class EnrichedItemDTOMapper {
    public static EnrichedItemDTO map(Item item, boolean drillDown, URI uri, Locale locale) {
        ItemDTO itemDTO = ItemDTOMapper.map((Item)item);
        return EnrichedItemDTOMapper.map(item, itemDTO, uri, drillDown, locale);
    }

    private static EnrichedItemDTO map(Item item, ItemDTO itemDTO, URI uri, boolean drillDown, Locale locale) {
        String state = EnrichedItemDTOMapper.considerTransformation(item.getState().toString(), item.getStateDescription(locale));
        StateDescription stateDescription = EnrichedItemDTOMapper.considerTransformation(item.getStateDescription(locale));
        String link = uri != null ? String.valueOf(uri.toASCIIString()) + "items" + "/" + itemDTO.name : null;
        EnrichedItemDTO enrichedItemDTO = null;
        if (item instanceof GroupItem) {
            EnrichedItemDTO[] memberDTOs;
            GroupItem groupItem = (GroupItem)item;
            String groupType = null;
            if (groupItem.getBaseItem() != null) {
                groupType = groupItem.getBaseItem().getType();
            }
            if (drillDown) {
                LinkedHashSet<EnrichedItemDTO> members = new LinkedHashSet<EnrichedItemDTO>();
                for (Item member : groupItem.getMembers()) {
                    members.add(EnrichedItemDTOMapper.map(member, drillDown, uri, locale));
                }
                memberDTOs = members.toArray(new EnrichedItemDTO[members.size()]);
            } else {
                memberDTOs = new EnrichedItemDTO[]{};
            }
            enrichedItemDTO = new EnrichedGroupItemDTO(itemDTO, groupType, memberDTOs, link, state, stateDescription);
        } else {
            enrichedItemDTO = new EnrichedItemDTO(itemDTO, link, state, stateDescription);
        }
        return enrichedItemDTO;
    }

    private static StateDescription considerTransformation(StateDescription desc) {
        if (desc == null || desc.getPattern() == null) {
            return desc;
        }
        try {
            return TransformationHelper.isTransform((String)desc.getPattern()) ? new StateDescription(desc.getMinimum(), desc.getMaximum(), desc.getStep(), "", desc.isReadOnly(), desc.getOptions()) : desc;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return desc;
        }
    }

    private static String considerTransformation(String state, StateDescription stateDescription) {
        if (stateDescription != null && stateDescription.getPattern() != null) {
            try {
                return TransformationHelper.transform((BundleContext)RESTCoreActivator.getBundleContext(), (String)stateDescription.getPattern(), (String)state.toString());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return state;
            }
        }
        return state;
    }
}

