/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.link;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.link.AbstractLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ThingLinkManager;
import org.eclipse.smarthome.core.thing.link.dto.AbstractLinkDTO;
import org.eclipse.smarthome.core.thing.link.dto.ItemChannelLinkDTO;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.RESTResource;

@Path(value="links")
@Api(value="links")
public class ItemChannelLinkResource
implements RESTResource {
    public static final String PATH_LINKS = "links";
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ThingLinkManager thingLinkManager;
    @Context
    UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets all available links.", response=ItemChannelLinkDTO.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll() {
        Collection channelLinks = this.itemChannelLinkRegistry.getAll();
        return Response.ok(this.toBeans(channelLinks)).build();
    }

    @GET
    @Path(value="/auto")
    @Produces(value={"application/json"})
    @ApiOperation(value="Tells whether automatic link mode is active or not", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response isAutomatic() {
        return Response.ok((Object)this.thingLinkManager.isAutoLinksEnabled()).build();
    }

    @PUT
    @Path(value="/{itemName}/{channelUID}")
    @ApiOperation(value="Links item to a channel.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Item already linked to the channel.")})
    public Response link(@PathParam(value="itemName") @ApiParam(value="itemName") String itemName, @PathParam(value="channelUID") @ApiParam(value="channelUID") String channelUid) {
        this.itemChannelLinkRegistry.add((Object)new ItemChannelLink(itemName, new ChannelUID(channelUid)));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{itemName}/{channelUID}")
    @ApiOperation(value="Unlinks item from a channel.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Link not found."), @ApiResponse(code=405, message="Link not editable.")})
    public Response unlink(@PathParam(value="itemName") @ApiParam(value="itemName") String itemName, @PathParam(value="channelUID") @ApiParam(value="channelUID") String channelUid) {
        String linkId = AbstractLink.getIDFor((String)itemName, (UID)new ChannelUID(channelUid));
        if (this.itemChannelLinkRegistry.get(linkId) == null) {
            String message = "Link " + linkId + " does not exist!";
            return JSONResponse.createResponse((Response.Status)Response.Status.NOT_FOUND, null, (String)message);
        }
        ItemChannelLink result = (ItemChannelLink)this.itemChannelLinkRegistry.remove((Object)AbstractLink.getIDFor((String)itemName, (UID)new ChannelUID(channelUid)));
        if (result != null) {
            return Response.ok().build();
        }
        return JSONResponse.createErrorResponse((Response.Status)Response.Status.METHOD_NOT_ALLOWED, (String)"Channel is read-only.");
    }

    protected void setThingLinkManager(ThingLinkManager thingLinkManager) {
        this.thingLinkManager = thingLinkManager;
    }

    protected void unsetThingLinkManager(ThingLinkManager thingLinkManager) {
        this.thingLinkManager = null;
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    private Collection<AbstractLinkDTO> toBeans(Iterable<ItemChannelLink> links) {
        ArrayList<AbstractLinkDTO> beans = new ArrayList<AbstractLinkDTO>();
        for (AbstractLink abstractLink : links) {
            ItemChannelLinkDTO bean = new ItemChannelLinkDTO(abstractLink.getItemName(), abstractLink.getUID().toString());
            beans.add((AbstractLinkDTO)bean);
        }
        return beans;
    }
}

