/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.core.config.ConfigurationService;
import org.eclipse.smarthome.io.rest.core.internal.RESTCoreActivator;
import org.eclipse.smarthome.io.rest.core.service.ConfigurableServiceDTO;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="services")
@Api(value="services")
public class ConfigurableServiceResource
implements RESTResource {
    public static final String PATH_SERVICES = "services";
    private static final String CONFIGURABLE_SERVICE_FILTER = "(service.config.description.uri=*)";
    private final Logger logger = LoggerFactory.getLogger(ConfigurableServiceResource.class);
    private ConfigurationService configurationService;

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all configurable services.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public List<ConfigurableServiceDTO> getAll() {
        List<ConfigurableServiceDTO> services = this.getConfigurableServices();
        return services;
    }

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get configurable service for given service ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not found")})
    public Response getById(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId) {
        List<ConfigurableServiceDTO> configurableServices = this.getConfigurableServices();
        for (ConfigurableServiceDTO configurableService : configurableServices) {
            if (!configurableService.id.equals(serviceId)) continue;
            return Response.ok((Object)configurableService).build();
        }
        return Response.status((int)404).build();
    }

    @GET
    @Path(value="/{serviceId}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get service configuration for given service ID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Configuration can not be read due to internal error")})
    public Response getConfiguration(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId) {
        try {
            Configuration configuration = this.configurationService.get(serviceId);
            return configuration != null ? Response.ok((Object)configuration.getProperties()).build() : Response.ok(Collections.emptyMap()).build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot get configuration for service {}: " + ex.getMessage(), (Object)serviceId, (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="/{serviceId}/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a service configuration for given service ID and returns the old configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=204, message="No old configuration"), @ApiResponse(code=500, message="Configuration can not be updated due to internal error")})
    public Response updateConfiguration(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId, Map<String, Object> configuration) {
        try {
            Configuration oldConfiguration = this.configurationService.get(serviceId);
            this.configurationService.update(serviceId, new Configuration(configuration));
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration.getProperties()).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot update configuration for service {}: " + ex.getMessage(), (Object)serviceId, (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/{serviceId}/config")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a service configuration for given service ID and returns the old configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=204, message="No old configuration"), @ApiResponse(code=500, message="Configuration can not be deleted due to internal error")})
    public Response deleteConfiguration(@PathParam(value="serviceId") @ApiParam(value="service ID", required=true) String serviceId) {
        try {
            Configuration oldConfiguration = this.configurationService.get(serviceId);
            this.configurationService.delete(serviceId);
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot delete configuration for service {}: " + ex.getMessage(), (Object)serviceId, (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<ConfigurableServiceDTO> getConfigurableServices() {
        ArrayList<ConfigurableServiceDTO> services = new ArrayList<ConfigurableServiceDTO>();
        try {
            ServiceReference[] serviceReferences = RESTCoreActivator.getBundleContext().getServiceReferences(null, CONFIGURABLE_SERVICE_FILTER);
            if (serviceReferences != null) {
                ServiceReference[] serviceReferenceArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    String id = this.getServiceId(serviceReference);
                    String label = (String)serviceReference.getProperty("service.config.label");
                    String category = (String)serviceReference.getProperty("service.config.category");
                    String configDescriptionURI = (String)serviceReference.getProperty("service.config.description.uri");
                    services.add(new ConfigurableServiceDTO(id, label, category, configDescriptionURI));
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException ex) {
            this.logger.error("Cannot get service references, because syntax is invalid: " + ex.getMessage(), (Throwable)ex);
        }
        return services;
    }

    private String getServiceId(ServiceReference<?> serviceReference) {
        Object pid = serviceReference.getProperty("service.pid");
        if (pid != null) {
            return (String)pid;
        }
        return (String)serviceReference.getProperty("component.name");
    }

    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void unsetConfigurationService(ConfigurationService configurationService) {
        this.configurationService = null;
    }
}

