/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.rest.core.thing;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.core.ConfigDescriptionRegistry;
import org.eclipse.smarthome.config.core.ConfigUtil;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.status.ConfigStatusInfo;
import org.eclipse.smarthome.config.core.status.ConfigStatusService;
import org.eclipse.smarthome.config.core.validation.ConfigValidationException;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ManagedItemProvider;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ManagedThingProvider;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.eclipse.smarthome.core.thing.dto.ChannelDTO;
import org.eclipse.smarthome.core.thing.dto.ChannelDTOMapper;
import org.eclipse.smarthome.core.thing.dto.ThingDTO;
import org.eclipse.smarthome.core.thing.dto.ThingDTOMapper;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.link.ManagedItemChannelLinkProvider;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeRegistry;
import org.eclipse.smarthome.core.thing.util.ThingHelper;
import org.eclipse.smarthome.io.rest.JSONResponse;
import org.eclipse.smarthome.io.rest.LocaleUtil;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.eclipse.smarthome.io.rest.core.thing.EnrichedThingDTO;
import org.eclipse.smarthome.io.rest.core.thing.EnrichedThingDTOMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="things")
@Api(value="things")
public class ThingResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(ThingResource.class);
    public static final String PATH_THINGS = "things";
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    private ItemFactory itemFactory;
    private ItemRegistry itemRegistry;
    private ManagedItemChannelLinkProvider managedItemChannelLinkProvider;
    private ManagedItemProvider managedItemProvider;
    private ManagedThingProvider managedThingProvider;
    private ThingRegistry thingRegistry;
    private ConfigStatusService configStatusService;
    private ConfigDescriptionRegistry configDescRegistry;
    private ThingTypeRegistry thingTypeRegistry;
    @Context
    private UriInfo uriInfo;

    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new thing and adds it to the registry.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="A uid must be provided, if no binding can create a thing of this type."), @ApiResponse(code=409, message="A thing with the same uid already exists.")})
    public Response create(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @ApiParam(value="thing data", required=true) ThingDTO thingBean) {
        Configuration configuration;
        Thing thing;
        Thing thing2;
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUID = thingBean.UID == null ? null : new ThingUID(thingBean.UID);
        ThingTypeUID thingTypeUID = new ThingTypeUID(thingBean.thingTypeUID);
        if (thingUID != null && (thing2 = this.thingRegistry.get(thingUID)) != null) {
            return this.getThingResponse(Response.Status.CONFLICT, thing2, locale, "Thing " + thingUID.toString() + " already exists!");
        }
        ThingUID bridgeUID = null;
        if (thingBean.bridgeUID != null) {
            bridgeUID = new ThingUID(thingBean.bridgeUID);
        }
        if ((thing = this.thingRegistry.createThingOfType(thingTypeUID, thingUID, bridgeUID, thingBean.label, configuration = new Configuration(this.normalizeConfiguration(thingBean.configuration, thingTypeUID)))) != null) {
            if (thingBean.properties != null) {
                for (Map.Entry entry : thingBean.properties.entrySet()) {
                    thing.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (thingBean.channels != null) {
                HashSet<Channel> channels = new HashSet<Channel>();
                for (ChannelDTO channelDTO : thingBean.channels) {
                    channels.add(ChannelDTOMapper.map((ChannelDTO)channelDTO));
                }
                ThingHelper.addChannelsToThing((Thing)thing, channels);
            }
        } else if (thingUID != null) {
            thing = ThingDTOMapper.map((ThingDTO)thingBean);
        } else {
            return this.getThingResponse(Response.Status.BAD_REQUEST, thing, locale, "A UID must be provided, since no binding can create the thing!");
        }
        this.thingRegistry.add((Object)thing);
        return this.getThingResponse(Response.Status.CREATED, thing, locale, "Thing " + thingUID.toString() + " already exists!");
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all available things.", response=EnrichedThingDTO.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response getAll(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Collection things = this.thingRegistry.getAll();
        Set<EnrichedThingDTO> thingBeans = this.convertToListBean(things, locale);
        return Response.ok(thingBeans).build();
    }

    @GET
    @Path(value="/{thingUID}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets thing by UID.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Thing with provided thingUID does not exist.")})
    public Response getByUID(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID) {
        Locale locale = LocaleUtil.getLocale((String)language);
        Thing thing = this.thingRegistry.get(new ThingUID(thingUID));
        if (thing != null) {
            return this.getThingResponse(Response.Status.OK, thing, locale, null);
        }
        return ThingResource.getThingNotFoundResponse(thingUID);
    }

    @POST
    @Path(value="/{thingUID}/channels/{channelId}/link")
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Links item to a channel. Creates item if such does not exist yet.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Thing not found or channel not found")})
    public Response link(@PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID, @PathParam(value="channelId") @ApiParam(value="channelId") String channelId, @ApiParam(value="item name") String itemName) {
        Thing thing = this.thingRegistry.get(new ThingUID(thingUID));
        if (thing == null) {
            this.logger.warn("Received HTTP POST request at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Channel channel = this.findChannel(channelId, thing);
        if (channel == null) {
            this.logger.info("Received HTTP POST request at '{}' for the unknown channel '{}' of the thing '{}'", new Object[]{this.uriInfo.getPath(), channel, thingUID});
            String message = "Channel " + channelId + " for Thing " + thingUID + " does not exist!";
            return JSONResponse.createResponse((Response.Status)Response.Status.NOT_FOUND, null, (String)message);
        }
        try {
            this.itemRegistry.getItem(itemName);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            GenericItem item = this.itemFactory.createItem(channel.getAcceptedItemType(), itemName);
            this.managedItemProvider.add((Object)item);
        }
        ChannelUID channelUID = new ChannelUID(thing.getUID(), channelId);
        this.unlinkChannelIfAlreadyLinked(channelUID);
        this.managedItemChannelLinkProvider.add((Object)new ItemChannelLink(itemName, channelUID));
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{thingUID}")
    @ApiOperation(value="Removes a thing from the registry. Set 'force' to __true__ if you want the thing te be removed immediately.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Thing not found.")})
    public Response remove(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID, @DefaultValue(value="false") @QueryParam(value="force") @ApiParam(value="force") boolean force) {
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP DELETE request for update at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP DELETE request for update at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot delete Thing " + thingUID + ". Maybe it is not managed.");
        }
        if (force) {
            if (this.thingRegistry.forceRemove(thingUIDObject) == null) {
                return this.getThingResponse(Response.Status.INTERNAL_SERVER_ERROR, thing, locale, "Cannot delete Thing " + thingUID + " for unknown reasons.");
            }
        } else if (this.thingRegistry.remove(thingUIDObject) != null) {
            return this.getThingResponse(Response.Status.ACCEPTED, thing, locale, null);
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{thingUID}/channels/{channelId}/link")
    @ApiOperation(value="Unlinks item from a channel.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    public Response unlink(@PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID, @PathParam(value="channelId") @ApiParam(value="channelId") String channelId, @ApiParam(value="channelId") String itemName) {
        Thing thing = this.thingRegistry.get(new ThingUID(thingUID));
        if (thing == null) {
            this.logger.warn("Received HTTP POST request at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        ChannelUID channelUID = new ChannelUID(new ThingUID(thingUID), channelId);
        if (this.itemChannelLinkRegistry.isLinked(itemName, (UID)channelUID)) {
            this.managedItemChannelLinkProvider.remove((Object)new ItemChannelLink(itemName, channelUID).getID());
        }
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{thingUID}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates a thing.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Thing not found")})
    public Response update(@HeaderParam(value="Accept-Language") @ApiParam(value="language") String language, @PathParam(value="thingUID") @ApiParam(value="thingUID") String thingUID, @ApiParam(value="thing", required=true) ThingDTO thingBean) throws IOException {
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP PUT request for update at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot update Thing " + thingUID + ". Maybe it is not managed.");
        }
        thingBean.configuration = this.normalizeConfiguration(thingBean.configuration, thing.getThingTypeUID());
        Thing oldthing = (Thing)this.managedThingProvider.update((Object)(thing = ThingHelper.merge((Thing)thing, (ThingDTO)thingBean)));
        if (oldthing == null) {
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        return this.getThingResponse(Response.Status.OK, thing, locale, null);
    }

    @PUT
    @Path(value="/{thingUID}/config")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Updates thing's configuration.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Thing not found")})
    public Response updateConfiguration(@HeaderParam(value="Accept-Language") String language, @PathParam(value="thingUID") @ApiParam(value="thing") String thingUID, @ApiParam(value="configuration parameters") Map<String, Object> configurationParameters) throws IOException {
        Locale locale = LocaleUtil.getLocale((String)language);
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP PUT request for update configuration at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        Thing managed = (Thing)this.managedThingProvider.get((Object)thingUIDObject);
        if (managed == null) {
            this.logger.info("Received HTTP PUT request for update configuration at '{}' for an unmanaged thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return this.getThingResponse(Response.Status.CONFLICT, thing, locale, "Cannot update Thing " + thingUID + ". Maybe it is not managed.");
        }
        try {
            this.thingRegistry.updateConfiguration(thingUIDObject, new Configuration(this.normalizeConfiguration(configurationParameters, thing.getThingTypeUID())).getProperties());
        }
        catch (ConfigValidationException ex) {
            this.logger.debug("Config description validation exception occured for thingUID {} - Messages: {}", (Object)thingUID, (Object)ex.getValidationMessages());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ex.getValidationMessages(locale)).build();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.info("Received HTTP PUT request for update config at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        return this.getThingResponse(Response.Status.OK, thing, locale, null);
    }

    @GET
    @Path(value="/{thingUID}/config/status")
    @ApiOperation(value="Gets thing's config status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Thing not found.")})
    public Response getConfigStatus(@HeaderParam(value="Accept-Language") String language, @PathParam(value="thingUID") @ApiParam(value="thing") String thingUID) throws IOException {
        ThingUID thingUIDObject = new ThingUID(thingUID);
        Thing thing = this.thingRegistry.get(thingUIDObject);
        if (thing == null) {
            this.logger.info("Received HTTP GET request for thing config status at '{}' for the unknown thing '{}'.", (Object)this.uriInfo.getPath(), (Object)thingUID);
            return ThingResource.getThingNotFoundResponse(thingUID);
        }
        ConfigStatusInfo info = this.configStatusService.getConfigStatus(thingUID, LocaleUtil.getLocale((String)language));
        if (info != null) {
            return Response.ok().entity((Object)info.getConfigStatusMessages()).build();
        }
        return Response.ok().entity((Object)Collections.EMPTY_SET).build();
    }

    private static Response getThingNotFoundResponse(String thingUID) {
        String message = "Thing " + thingUID + " does not exist!";
        return JSONResponse.createResponse((Response.Status)Response.Status.NOT_FOUND, null, (String)message);
    }

    private Response getThingResponse(Response.Status status, Thing thing, Locale locale, String errormessage) {
        EnrichedThingDTO entity = thing != null ? EnrichedThingDTOMapper.map(thing, this.uriInfo.getBaseUri(), locale, this.getLinkedItemsMap(thing)) : null;
        return JSONResponse.createResponse((Response.Status)status, entity, (String)errormessage);
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
    }

    protected void setItemFactory(ItemFactory itemFactory) {
        this.itemFactory = itemFactory;
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void setManagedItemChannelLinkProvider(ManagedItemChannelLinkProvider managedItemChannelLinkProvider) {
        this.managedItemChannelLinkProvider = managedItemChannelLinkProvider;
    }

    protected void setManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = managedItemProvider;
    }

    protected void setManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = managedThingProvider;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    protected void unsetItemFactory(ItemFactory itemFactory) {
        this.itemFactory = null;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void unsetManagedItemChannelLinkProvider(ManagedItemChannelLinkProvider managedItemChannelLinkProvider) {
        this.managedItemChannelLinkProvider = null;
    }

    protected void unsetManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = null;
    }

    protected void unsetManagedThingProvider(ManagedThingProvider managedThingProvider) {
        this.managedThingProvider = null;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    protected void setConfigStatusService(ConfigStatusService configStatusService) {
        this.configStatusService = configStatusService;
    }

    protected void unsetConfigStatusService(ConfigStatusService configStatusService) {
        this.configStatusService = null;
    }

    private Set<EnrichedThingDTO> convertToListBean(Collection<Thing> things, Locale locale) {
        LinkedHashSet<EnrichedThingDTO> thingBeans = new LinkedHashSet<EnrichedThingDTO>();
        for (Thing thing : things) {
            EnrichedThingDTO thingBean = EnrichedThingDTOMapper.map(thing, this.uriInfo.getBaseUri(), locale, this.getLinkedItemsMap(thing));
            thingBeans.add(thingBean);
        }
        return thingBeans;
    }

    private Map<String, Set<String>> getLinkedItemsMap(Thing thing) {
        HashMap<String, Set<String>> linkedItemsMap = new HashMap<String, Set<String>>();
        for (Channel channel : thing.getChannels()) {
            Set linkedItems = this.itemChannelLinkRegistry.getLinkedItems((UID)channel.getUID());
            linkedItemsMap.put(channel.getUID().getId(), linkedItems);
        }
        return linkedItemsMap;
    }

    private Channel findChannel(String channelId, Thing thing) {
        for (Channel channel : thing.getChannels()) {
            if (!channel.getUID().getId().equals(channelId)) continue;
            return channel;
        }
        return null;
    }

    private void unlinkChannelIfAlreadyLinked(ChannelUID channelUID) {
        Collection links = this.managedItemChannelLinkProvider.getAll();
        for (ItemChannelLink link : links) {
            if (!link.getUID().equals((Object)channelUID)) continue;
            this.logger.debug("Channel '{}' is already linked to item '{}' and will be unlinked before it will be linked to the new item.", (Object)channelUID, (Object)link.getItemName());
            this.managedItemChannelLinkProvider.remove((Object)link.getID());
        }
    }

    public static void updateConfiguration(Thing thing, Configuration configuration) {
        for (String parameterName : configuration.keySet()) {
            thing.getConfiguration().put(parameterName, configuration.get(parameterName));
        }
    }

    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescRegistry = null;
    }

    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    private Map<String, Object> normalizeConfiguration(Map<String, Object> properties, ThingTypeUID thingTypeUID) {
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID);
        if (thingType == null) {
            return properties;
        }
        ConfigDescription configDesc = this.configDescRegistry.getConfigDescription(thingType.getConfigDescriptionURI());
        if (configDesc == null) {
            return properties;
        }
        return ConfigUtil.normalizeTypes(properties, (ConfigDescription)configDesc);
    }
}

