/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelXmlResult;

public class ChannelGroupTypeXmlResult {
    private ChannelGroupTypeUID channelGroupTypeUID;
    private boolean advanced;
    private String label;
    private String description;
    private List<ChannelXmlResult> channelTypeReferences;

    public ChannelGroupTypeXmlResult(ChannelGroupTypeUID channelGroupTypeUID, boolean advanced, String label, String description, List<ChannelXmlResult> channelTypeReferences) {
        this.channelGroupTypeUID = channelGroupTypeUID;
        this.advanced = advanced;
        this.label = label;
        this.description = description;
        this.channelTypeReferences = channelTypeReferences;
    }

    public ChannelGroupTypeUID getUID() {
        return this.channelGroupTypeUID;
    }

    protected List<ChannelDefinition> toChannelDefinitions(List<ChannelXmlResult> channelTypeReferences, Map<String, ChannelType> channelTypes) throws ConversionException {
        ArrayList<ChannelDefinition> channelTypeDefinitions = null;
        if (channelTypeReferences != null && channelTypeReferences.size() > 0) {
            channelTypeDefinitions = new ArrayList<ChannelDefinition>(channelTypeReferences.size());
            if (channelTypes != null) {
                for (ChannelXmlResult channelTypeReference : channelTypeReferences) {
                    String id = channelTypeReference.getId();
                    String typeId = channelTypeReference.getTypeId();
                    String typeUID = String.format("%s:%s", this.channelGroupTypeUID.getBindingId(), typeId);
                    ChannelType channelType = channelTypes.get(typeUID);
                    if (channelType != null) {
                        ChannelDefinition channelDefinition = new ChannelDefinition(id, channelType.getUID());
                        channelTypeDefinitions.add(channelDefinition);
                        continue;
                    }
                    throw new ConversionException("The channel type for '" + typeUID + "' is missing!");
                }
            } else {
                throw new ConversionException("Missing the definition of channel types!");
            }
        }
        return channelTypeDefinitions;
    }

    public ChannelGroupType toChannelGroupType(Map<String, ChannelType> channelTypes) throws ConversionException {
        ChannelGroupType channelGroupType = new ChannelGroupType(this.channelGroupTypeUID, this.advanced, this.label, this.description, this.toChannelDefinitions(this.channelTypeReferences, channelTypes));
        return channelGroupType;
    }

    public String toString() {
        return "ChannelGroupTypeXmlResult [channelGroupTypeUID=" + this.channelGroupTypeUID + ", advanced=" + this.advanced + ", label=" + this.label + ", description=" + this.description + ", channelTypeReferences=" + this.channelTypeReferences + "]";
    }
}

