/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelXmlResult;
import org.eclipse.smarthome.core.thing.xml.internal.XmlHelper;

public class ThingTypeXmlResult {
    protected ThingTypeUID thingTypeUID;
    protected List<String> supportedBridgeTypeUIDs;
    protected String label;
    protected String description;
    protected boolean listed;
    protected List<ChannelXmlResult> channelTypeReferences;
    protected List<ChannelXmlResult> channelGroupTypeReferences;
    protected List<NodeValue> properties;
    protected URI configDescriptionURI;
    protected ConfigDescription configDescription;

    public ThingTypeXmlResult(ThingTypeUID thingTypeUID, List<String> supportedBridgeTypeUIDs, String label, String description, boolean listed, List<ChannelXmlResult>[] channelTypeReferenceObjects, List<NodeValue> properties, Object[] configDescriptionObjects) {
        this.thingTypeUID = thingTypeUID;
        this.supportedBridgeTypeUIDs = supportedBridgeTypeUIDs;
        this.label = label;
        this.description = description;
        this.listed = listed;
        this.channelTypeReferences = channelTypeReferenceObjects[0];
        this.channelGroupTypeReferences = channelTypeReferenceObjects[1];
        this.properties = properties;
        this.configDescriptionURI = (URI)configDescriptionObjects[0];
        this.configDescription = (ConfigDescription)configDescriptionObjects[1];
    }

    public ConfigDescription getConfigDescription() {
        return this.configDescription;
    }

    protected List<ChannelDefinition> toChannelDefinitions(List<ChannelXmlResult> channelTypeReferences) throws ConversionException {
        ArrayList<ChannelDefinition> channelTypeDefinitions = null;
        if (channelTypeReferences != null && channelTypeReferences.size() > 0) {
            channelTypeDefinitions = new ArrayList<ChannelDefinition>(channelTypeReferences.size());
            for (ChannelXmlResult channelTypeReference : channelTypeReferences) {
                String id = channelTypeReference.getId();
                String typeId = channelTypeReference.getTypeId();
                String typeUID = String.format("%s:%s", this.thingTypeUID.getBindingId(), typeId);
                int systemPrefixIdx = typeId.indexOf("system.");
                if (systemPrefixIdx != -1) {
                    typeUID = XmlHelper.getSystemUID(typeId);
                }
                HashMap<String, String> propertiesMap = new HashMap<String, String>();
                for (NodeValue property : channelTypeReference.getProperties()) {
                    propertiesMap.put((String)property.getAttributes().get("name"), (String)property.getValue());
                }
                ChannelDefinition channelDefinition = new ChannelDefinition(id, new ChannelTypeUID(typeUID), propertiesMap, channelTypeReference.getLabel(), channelTypeReference.getDescription());
                channelTypeDefinitions.add(channelDefinition);
            }
        }
        return channelTypeDefinitions;
    }

    protected List<ChannelGroupDefinition> toChannelGroupDefinitions(List<ChannelXmlResult> channelGroupTypeReferences) throws ConversionException {
        ArrayList<ChannelGroupDefinition> channelGroupTypeDefinitions = null;
        if (channelGroupTypeReferences != null && channelGroupTypeReferences.size() > 0) {
            channelGroupTypeDefinitions = new ArrayList<ChannelGroupDefinition>(channelGroupTypeReferences.size());
            for (ChannelXmlResult channelGroupTypeReference : channelGroupTypeReferences) {
                String id = channelGroupTypeReference.getId();
                String typeId = channelGroupTypeReference.getTypeId();
                String typeUID = String.format("%s:%s", this.thingTypeUID.getBindingId(), typeId);
                ChannelGroupDefinition channelGroupDefinition = new ChannelGroupDefinition(id, new ChannelGroupTypeUID(typeUID));
                channelGroupTypeDefinitions.add(channelGroupDefinition);
            }
        }
        return channelGroupTypeDefinitions;
    }

    protected Map<String, String> toPropertiesMap() {
        if (this.properties == null) {
            return null;
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (NodeValue property : this.properties) {
            propertiesMap.put((String)property.getAttributes().get("name"), (String)property.getValue());
        }
        return propertiesMap;
    }

    public ThingType toThingType() throws ConversionException {
        ThingType thingType = new ThingType(this.thingTypeUID, this.supportedBridgeTypeUIDs, this.label, this.description, this.listed, this.toChannelDefinitions(this.channelTypeReferences), this.toChannelGroupDefinitions(this.channelGroupTypeReferences), this.toPropertiesMap(), this.configDescriptionURI);
        return thingType;
    }

    public String toString() {
        return "ThingTypeXmlResult [thingTypeUID=" + this.thingTypeUID + ", supportedBridgeTypeUIDs=" + this.supportedBridgeTypeUIDs + ", label=" + this.label + ", description=" + this.description + ", listed=" + this.listed + ", channelTypeReferences=" + this.channelTypeReferences + ", channelGroupTypeReferences=" + this.channelGroupTypeReferences + ", properties=" + this.properties + ", configDescriptionURI=" + this.configDescriptionURI + ", configDescription=" + this.configDescription + "]";
    }
}

