/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.core.common.osgi.ServiceBinder;
import org.eclipse.smarthome.core.i18n.I18nProvider;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ThingTypeProvider;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.type.BridgeType;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.osgi.framework.Bundle;

public class XmlThingTypeProvider
implements ThingTypeProvider {
    private Map<LocalizedThingTypeKey, ThingType> localizedThingTypeCache = new HashMap<LocalizedThingTypeKey, ThingType>();
    private Map<Bundle, List<ThingType>> bundleThingTypesMap = new HashMap<Bundle, List<ThingType>>(10);
    private ThingTypeI18nUtil thingTypeI18nUtil;

    private List<ThingType> acquireThingTypes(Bundle bundle) {
        if (bundle != null) {
            List<ThingType> thingTypes = this.bundleThingTypesMap.get(bundle);
            if (thingTypes == null) {
                thingTypes = new ArrayList<ThingType>(10);
                this.bundleThingTypesMap.put(bundle, thingTypes);
            }
            return thingTypes;
        }
        return null;
    }

    public synchronized void addThingType(Bundle bundle, ThingType thingType) {
        List<ThingType> thingTypes;
        if (thingType != null && (thingTypes = this.acquireThingTypes(bundle)) != null) {
            thingTypes.add(thingType);
            this.removeCachedEntries(thingType);
        }
    }

    private ThingType createLocalizedThingType(Bundle bundle, ThingType thingType, Locale locale) {
        LocalizedThingTypeKey localizedThingTypeKey = this.getLocalizedThingTypeKey(thingType, locale);
        ThingType cacheEntry = this.localizedThingTypeCache.get(localizedThingTypeKey);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        if (this.thingTypeI18nUtil != null) {
            String label = this.thingTypeI18nUtil.getLabel(bundle, thingType.getUID(), thingType.getLabel(), locale);
            String description = this.thingTypeI18nUtil.getDescription(bundle, thingType.getUID(), thingType.getDescription(), locale);
            ArrayList<ChannelDefinition> localizedChannelDefinitions = new ArrayList<ChannelDefinition>(thingType.getChannelDefinitions().size());
            for (ChannelDefinition channelDefinition : thingType.getChannelDefinitions()) {
                localizedChannelDefinitions.add(channelDefinition);
            }
            ArrayList<ChannelGroupDefinition> localizedChannelGroupDefinitions = new ArrayList<ChannelGroupDefinition>(thingType.getChannelGroupDefinitions().size());
            for (ChannelGroupDefinition channelGroupDefinition : thingType.getChannelGroupDefinitions()) {
                localizedChannelGroupDefinitions.add(channelGroupDefinition);
            }
            if (thingType instanceof BridgeType) {
                BridgeType bridgeType = (BridgeType)thingType;
                BridgeType localizedBridgeType = new BridgeType(bridgeType.getUID(), bridgeType.getSupportedBridgeTypeUIDs(), label, description, thingType.isListed(), localizedChannelDefinitions, localizedChannelGroupDefinitions, thingType.getProperties(), bridgeType.getConfigDescriptionURI());
                this.localizedThingTypeCache.put(localizedThingTypeKey, (ThingType)localizedBridgeType);
                return localizedBridgeType;
            }
            ThingType localizedThingType = new ThingType(thingType.getUID(), thingType.getSupportedBridgeTypeUIDs(), label, description, thingType.isListed(), localizedChannelDefinitions, localizedChannelGroupDefinitions, thingType.getProperties(), thingType.getConfigDescriptionURI());
            this.localizedThingTypeCache.put(localizedThingTypeKey, localizedThingType);
            return localizedThingType;
        }
        return thingType;
    }

    private LocalizedThingTypeKey getLocalizedThingTypeKey(ThingType thingType, Locale locale) {
        String localeString = locale != null ? locale.toLanguageTag() : null;
        LocalizedThingTypeKey localizedThingTypeKey = new LocalizedThingTypeKey(thingType.getUID(), locale != null ? localeString : null);
        return localizedThingTypeKey;
    }

    private void removeCachedEntries(List<ThingType> thingTypes) {
        for (ThingType thingType : thingTypes) {
            this.removeCachedEntries(thingType);
        }
    }

    private void removeCachedEntries(ThingType thingType) {
        Iterator<Map.Entry<LocalizedThingTypeKey, ThingType>> iterator = this.localizedThingTypeCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<LocalizedThingTypeKey, ThingType> entry = iterator.next();
            if (!entry.getKey().uid.equals((Object)thingType.getUID())) continue;
            iterator.remove();
        }
    }

    public ThingType getThingType(ThingTypeUID thingTypeUID, Locale locale) {
        Set<Map.Entry<Bundle, List<ThingType>>> thingTypesList = this.bundleThingTypesMap.entrySet();
        if (thingTypesList != null) {
            for (Map.Entry entry : thingTypesList) {
                for (ThingType thingType : (List)entry.getValue()) {
                    if (!thingType.getUID().equals((Object)thingTypeUID)) continue;
                    return this.createLocalizedThingType((Bundle)entry.getKey(), thingType, locale);
                }
            }
        }
        return null;
    }

    public synchronized Collection<ThingType> getThingTypes(Locale locale) {
        ArrayList<ThingType> allThingTypes = new ArrayList<ThingType>(10);
        Set<Map.Entry<Bundle, List<ThingType>>> thingTypesList = this.bundleThingTypesMap.entrySet();
        if (thingTypesList != null) {
            for (Map.Entry entry : thingTypesList) {
                for (ThingType thingType : (List)entry.getValue()) {
                    ThingType localizedThingType = this.createLocalizedThingType((Bundle)entry.getKey(), thingType, locale);
                    allThingTypes.add(localizedThingType);
                }
            }
        }
        return allThingTypes;
    }

    public synchronized void removeAllThingTypes(Bundle bundle) {
        List<ThingType> thingTypes;
        if (bundle != null && (thingTypes = this.bundleThingTypesMap.get(bundle)) != null) {
            this.bundleThingTypesMap.remove(bundle);
            this.removeCachedEntries(thingTypes);
        }
    }

    @ServiceBinder.Bind
    public void setI18nProvider(I18nProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    @ServiceBinder.Unbind
    public void unsetI18nProvider(I18nProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    private class LocalizedThingTypeKey {
        public ThingTypeUID uid;
        public String locale;

        public LocalizedThingTypeKey(ThingTypeUID uid, String locale) {
            this.uid = uid;
            this.locale = locale;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.uid == null ? 0 : this.uid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocalizedThingTypeKey other = (LocalizedThingTypeKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
                return false;
            }
            return !(this.uid == null ? other.uid != null : !this.uid.equals((Object)other.uid));
        }

        private XmlThingTypeProvider getOuterType() {
            return XmlThingTypeProvider.this;
        }
    }
}

