/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.handler;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.smarthome.binding.lifx.internal.LifxNetworkThrottler;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.protocol.EchoRequestResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetEchoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLightPowerRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetServiceRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketFactory;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketHandler;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PowerState;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetColorRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetLightPowerRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLabelResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StatePowerResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateServiceResponse;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifxLightHandler
extends BaseThingHandler {
    private Logger logger = LoggerFactory.getLogger(LifxLightHandler.class);
    private static final double INCREASE_DECREASE_STEP = 0.1;
    private final int BROADCAST_PORT = 56700;
    private static long NETWORK_INTERVAL = 50L;
    private static int ECHO_POLLING_INTERVAL = 15;
    private static int STATE_POLLING_INTERVAL = 3;
    private static int MAXIMUM_POLLING_RETRIES = 2;
    private static int lightCounter = 1;
    private static ReentrantLock lighCounterLock = new ReentrantLock();
    private long source;
    private int service;
    private int port;
    private long fadeTime = 300L;
    private MACAddress macAddress = null;
    private MACAddress broadcastAddress = new MACAddress("000000000000", true);
    private int sequenceNumber = 1;
    private PowerState currentPowerState;
    private HSBType currentColorState;
    private PercentType currentTempState;
    private Selector selector;
    private ScheduledFuture<?> networkJob;
    private ReentrantLock lock = new ReentrantLock();
    private long lastEchoPollingTimestamp = 0L;
    private long lastStatePollingTimestamp = 0L;
    private InetSocketAddress ipAddress = null;
    private DatagramChannel unicastChannel = null;
    private SelectionKey unicastKey = null;
    private SelectionKey broadcastKey = null;
    private List<InetSocketAddress> broadcastAddresses;
    private List<InetAddress> interfaceAddresses;
    private ConcurrentHashMap<Integer, Packet> sentPackets = new ConcurrentHashMap();
    private int bufferSize = 0;
    private Runnable networkRunnable = new Runnable(){

        @Override
        public void run() {
            block25: {
                block24: {
                    try {
                        try {
                            LifxLightHandler.this.lock.lock();
                            if (LifxLightHandler.this.selector == null) break block24;
                            try {
                                LifxLightHandler.this.selector.selectNow();
                            }
                            catch (IOException e) {
                                LifxLightHandler.this.logger.error("An exception occurred while selecting: {}", (Object)e.getMessage());
                            }
                            Set<SelectionKey> selectedKeys = LifxLightHandler.this.selector.selectedKeys();
                            for (SelectionKey selectionKey : selectedKeys) {
                                if (selectionKey.isValid() && selectionKey.isAcceptable() || selectionKey.isValid() && selectionKey.isConnectable()) continue;
                                if (selectionKey.isValid() && selectionKey.isReadable()) {
                                    SelectableChannel channel = selectionKey.channel();
                                    InetSocketAddress address = null;
                                    int messageLength = 0;
                                    ByteBuffer readBuffer = ByteBuffer.allocate(LifxLightHandler.this.bufferSize);
                                    try {
                                        if (channel instanceof DatagramChannel) {
                                            address = (InetSocketAddress)((DatagramChannel)channel).receive(readBuffer);
                                        } else if (channel instanceof SocketChannel) {
                                            address = (InetSocketAddress)((SocketChannel)channel).getRemoteAddress();
                                            ((SocketChannel)channel).read(readBuffer);
                                        }
                                        messageLength = readBuffer.position();
                                    }
                                    catch (Exception e) {
                                        LifxLightHandler.this.logger.warn("An exception occurred while reading data : '{}'", (Object)e.getMessage());
                                    }
                                    if (address == null || LifxLightHandler.this.interfaceAddresses.contains(address.getAddress())) continue;
                                    readBuffer.rewind();
                                    ByteBuffer packetSize = readBuffer.slice();
                                    packetSize.position(0);
                                    packetSize.limit(2);
                                    int size = Packet.FIELD_SIZE.value(packetSize);
                                    if (messageLength != size) continue;
                                    ByteBuffer packetType = readBuffer.slice();
                                    packetType.position(32);
                                    packetType.limit(34);
                                    int type = Packet.FIELD_PACKET_TYPE.value(packetType);
                                    PacketHandler<?> handler = PacketFactory.createHandler(type);
                                    if (handler == null) {
                                        LifxLightHandler.this.logger.trace("Unknown packet type: {} (source: {})", (Object)String.format("0x%02X", type), (Object)address.toString());
                                        continue;
                                    }
                                    Object packet = handler.handle(readBuffer);
                                    if (packet == null) {
                                        LifxLightHandler.this.logger.warn("Handler {} was unable to handle packet", (Object)handler.getClass().getName());
                                        continue;
                                    }
                                    LifxLightHandler.this.handlePacket(packet, address);
                                    continue;
                                }
                                if (!selectionKey.isValid()) continue;
                                selectionKey.isWritable();
                            }
                        }
                        catch (Exception e) {
                            LifxLightHandler.this.logger.error("An exception orccurred while communicating with the bulb : '{}'", (Object)e.getMessage());
                            LifxLightHandler.this.lock.unlock();
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        LifxLightHandler.this.lock.unlock();
                        throw throwable;
                    }
                }
                LifxLightHandler.this.lock.unlock();
            }
            if (System.currentTimeMillis() - LifxLightHandler.this.lastEchoPollingTimestamp > (long)(ECHO_POLLING_INTERVAL * 1000)) {
                if (LifxLightHandler.this.getThing().getStatus() != ThingStatus.OFFLINE) {
                    LifxLightHandler.this.logger.trace("{} : Polling", (Object)LifxLightHandler.this.macAddress.getHex());
                    int counter = 0;
                    for (Packet aPacket : LifxLightHandler.this.sentPackets.values()) {
                        if (!(aPacket instanceof GetEchoRequest)) continue;
                        ++counter;
                    }
                    LifxLightHandler.this.lastEchoPollingTimestamp = System.currentTimeMillis();
                    if (counter < MAXIMUM_POLLING_RETRIES) {
                        ByteBuffer payload = ByteBuffer.allocate(8);
                        payload.putLong(LifxLightHandler.this.lastEchoPollingTimestamp);
                        GetEchoRequest getEchoRequest = new GetEchoRequest();
                        getEchoRequest.setResponseRequired(true);
                        getEchoRequest.setPayload(payload);
                        LifxLightHandler.this.sendPacket(getEchoRequest);
                    } else {
                        LifxLightHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
                        LifxLightHandler.this.sentPackets.clear();
                    }
                } else {
                    LifxLightHandler.this.logger.trace("{} : The bulb is not online, let's broadcast instead", (Object)LifxLightHandler.this.macAddress.getHex());
                    LifxLightHandler.this.lastEchoPollingTimestamp = System.currentTimeMillis();
                    GetServiceRequest packet = new GetServiceRequest();
                    LifxLightHandler.this.broadcastPacket(packet);
                }
            }
            if (System.currentTimeMillis() - LifxLightHandler.this.lastStatePollingTimestamp > (long)(STATE_POLLING_INTERVAL * 1000)) {
                if (LifxLightHandler.this.getThing().getStatus() != ThingStatus.OFFLINE) {
                    LifxLightHandler.this.logger.trace("{} : Polling the state of the bulb", (Object)LifxLightHandler.this.macAddress.getHex());
                    LifxLightHandler.this.lastStatePollingTimestamp = System.currentTimeMillis();
                    GetLightPowerRequest powerPacket = new GetLightPowerRequest();
                    LifxLightHandler.this.sendPacket(powerPacket);
                    GetRequest colorPacket = new GetRequest();
                    LifxLightHandler.this.sendPacket(colorPacket);
                } else {
                    LifxLightHandler.this.logger.trace("{} : The bulb is not online, there is no point polling it", (Object)LifxLightHandler.this.macAddress.getHex());
                    LifxLightHandler.this.lastStatePollingTimestamp = System.currentTimeMillis();
                }
            }
        }
    };

    public LifxLightHandler(Thing thing) {
        super(thing);
    }

    public void dispose() {
        if (this.networkJob != null && !this.networkJob.isCancelled()) {
            this.networkJob.cancel(true);
            this.networkJob = null;
        }
        this.currentColorState = null;
        this.currentPowerState = null;
        try {
            if (this.selector != null) {
                this.selector.close();
            }
        }
        catch (IOException e) {
            this.logger.warn("An exception occurred while closing the selector : '{}'", (Object)e.getMessage());
        }
        if (this.broadcastKey != null) {
            try {
                this.broadcastKey.channel().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.unicastKey != null) {
            try {
                this.unicastKey.channel().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void initialize() {
        try {
            this.macAddress = new MACAddress((String)this.getConfig().get("deviceId"), true);
            this.logger.debug("Initializing the LIFX handler for bulb '{}'.", (Object)this.macAddress.getHex());
            Object fadeCfg = this.getConfig().get("fadetime");
            if (fadeCfg != null) {
                try {
                    this.fadeTime = Long.parseLong(fadeCfg.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.warn("Invalid value '{}' for transition time, using default instead.", (Object)fadeCfg.toString());
                }
            }
            if (this.networkJob == null || this.networkJob.isCancelled()) {
                this.networkJob = this.scheduler.scheduleWithFixedDelay(this.networkRunnable, 0L, NETWORK_INTERVAL, TimeUnit.MILLISECONDS);
            }
            this.source = UUID.randomUUID().getLeastSignificantBits() & 0xFFFFFFFFL;
            this.logger.debug("The LIFX handler will use '{}' as source identifier", (Object)Long.toString(this.source, 16));
            this.broadcastAddresses = new ArrayList<InetSocketAddress>();
            this.interfaceAddresses = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface iface = networkInterfaces.nextElement();
                if (!iface.isUp() || iface.isLoopback()) continue;
                for (InterfaceAddress ifaceAddr : iface.getInterfaceAddresses()) {
                    if (!(ifaceAddr.getAddress() instanceof Inet4Address)) continue;
                    this.logger.debug("Adding '{}' as interface address with MTU {}", (Object)ifaceAddr.getAddress(), (Object)iface.getMTU());
                    if (iface.getMTU() > this.bufferSize) {
                        this.bufferSize = iface.getMTU();
                    }
                    this.interfaceAddresses.add(ifaceAddr.getAddress());
                    if (ifaceAddr.getBroadcast() == null) continue;
                    this.logger.debug("Adding '{}' as broadcast address", (Object)ifaceAddr.getBroadcast());
                    this.broadcastAddresses.add(new InetSocketAddress(ifaceAddr.getBroadcast(), 56700));
                }
            }
            this.selector = Selector.open();
            NetworkChannel broadcastChannel = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)true);
            ((AbstractSelectableChannel)((Object)broadcastChannel)).configureBlocking(false);
            lighCounterLock.lock();
            this.logger.debug("Binding the broadcast channel on port {}", (Object)(56700 + lightCounter));
            ((DatagramChannel)broadcastChannel).bind(new InetSocketAddress(56700 + lightCounter));
            ++lightCounter;
            lighCounterLock.unlock();
            this.broadcastKey = ((SelectableChannel)((Object)broadcastChannel)).register(this.selector, 5);
            this.updateStatus(ThingStatus.OFFLINE);
            GetServiceRequest packet = new GetServiceRequest();
            this.broadcastPacket(packet);
        }
        catch (Exception ex) {
            this.logger.error("Error occured while initializing LIFX handler: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        try {
            switch (channelUID.getId()) {
                case "color": {
                    if (command instanceof HSBType) {
                        this.handleHSBCommand((HSBType)command);
                        return;
                    }
                }
                case "brightness": {
                    if (command instanceof PercentType) {
                        this.handlePercentCommand((PercentType)command);
                        break;
                    }
                    if (command instanceof OnOffType) {
                        this.handleOnOffCommand((OnOffType)command);
                        break;
                    }
                    if (command instanceof IncreaseDecreaseType) {
                        this.handleIncreaseDecreaseCommand((IncreaseDecreaseType)command);
                    }
                    break;
                }
                case "temperature": {
                    if (command instanceof PercentType) {
                        this.handleTemperatureCommand((PercentType)command);
                        break;
                    }
                    if (command instanceof IncreaseDecreaseType) {
                        this.handleIncreaseDecreaseTemperatureCommand((IncreaseDecreaseType)command);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error while updating bulb: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void handleTemperatureCommand(PercentType temperature) {
        SetColorRequest packet = new SetColorRequest((int)(this.currentColorState.getHue().floatValue() / 360.0f * 65535.0f), (int)(this.currentColorState.getSaturation().floatValue() / 100.0f * 65535.0f), (int)(this.currentColorState.getBrightness().floatValue() / 100.0f * 65535.0f), this.toKelvin(temperature.intValue()), this.fadeTime);
        packet.setResponseRequired(false);
        this.sendPacket(packet);
        GetRequest colorPacket = new GetRequest();
        this.sendPacket(colorPacket);
    }

    private void handleHSBCommand(HSBType hsbType) {
        SetColorRequest packet = new SetColorRequest((int)(hsbType.getHue().floatValue() / 360.0f * 65535.0f), (int)(hsbType.getSaturation().floatValue() / 100.0f * 65535.0f), (int)(hsbType.getBrightness().floatValue() / 100.0f * 65535.0f), this.toKelvin(this.currentTempState.intValue()), this.fadeTime);
        packet.setResponseRequired(false);
        this.sendPacket(packet);
        if (this.currentPowerState != PowerState.ON) {
            SetLightPowerRequest secondPacket = new SetLightPowerRequest(PowerState.ON);
            secondPacket.setResponseRequired(false);
            this.sendPacket(secondPacket);
        }
        GetLightPowerRequest powerPacket = new GetLightPowerRequest();
        this.sendPacket(powerPacket);
        GetRequest colorPacket = new GetRequest();
        this.sendPacket(colorPacket);
    }

    private void handlePercentCommand(PercentType percentType) {
        if (this.currentColorState != null) {
            HSBType newColorState = new HSBType(this.currentColorState.getHue(), this.currentColorState.getSaturation(), percentType);
            this.handleHSBCommand(newColorState);
        }
    }

    private void handleOnOffCommand(OnOffType onOffType) {
        PowerState lfxPowerState = onOffType == OnOffType.ON ? PowerState.ON : PowerState.OFF;
        SetLightPowerRequest packet = new SetLightPowerRequest(lfxPowerState);
        this.sendPacket(packet);
        GetLightPowerRequest powerPacket = new GetLightPowerRequest();
        this.sendPacket(powerPacket);
    }

    private void handleIncreaseDecreaseCommand(IncreaseDecreaseType increaseDecreaseType) {
        if (this.currentColorState != null) {
            float brightness = this.currentColorState.getBrightness().floatValue() / 100.0f;
            if (increaseDecreaseType == IncreaseDecreaseType.INCREASE && (brightness = (float)((double)brightness + 0.1)) > 1.0f) {
                brightness = 1.0f;
            }
            if (increaseDecreaseType == IncreaseDecreaseType.DECREASE && (brightness = (float)((double)brightness - 0.1)) < 0.0f) {
                brightness = 0.0f;
            }
            PercentType newBrightness = new PercentType(Math.round(brightness * 100.0f));
            this.handlePercentCommand(newBrightness);
        }
    }

    private void handleIncreaseDecreaseTemperatureCommand(IncreaseDecreaseType increaseDecreaseType) {
        if (this.currentTempState != null) {
            float temperature = this.currentTempState.floatValue() / 100.0f;
            if (increaseDecreaseType == IncreaseDecreaseType.INCREASE && (temperature = (float)((double)temperature + 0.1)) > 1.0f) {
                temperature = 1.0f;
            }
            if (increaseDecreaseType == IncreaseDecreaseType.DECREASE && (temperature = (float)((double)temperature - 0.1)) < 0.0f) {
                temperature = 0.0f;
            }
            PercentType newTemperature = new PercentType(Math.round(temperature * 100.0f));
            this.handleTemperatureCommand(newTemperature);
        }
    }

    private void sendPacket(Packet packet) {
        if (this.ipAddress != null) {
            packet.setSource(this.source);
            packet.setTarget(this.macAddress);
            if (this.sentPackets.containsKey(this.sequenceNumber)) {
                this.logger.warn("A messages with sequence number '{}' has already been sent to the bulb. Is it missing in action? ", (Object)this.sequenceNumber);
            }
            packet.setSequence(this.sequenceNumber);
            LifxNetworkThrottler.lock(this.macAddress.getAsLabel());
            this.sendPacket(packet, this.ipAddress, this.unicastKey);
            LifxNetworkThrottler.unlock(this.macAddress.getAsLabel());
            ++this.sequenceNumber;
            if (this.sequenceNumber > 255) {
                this.sequenceNumber = 1;
            }
        }
    }

    private void broadcastPacket(Packet packet) {
        if (this.sentPackets.containsKey(this.sequenceNumber)) {
            this.logger.warn("A messages with sequence number '{}' has already been sent to the bulb. Is it missing in action? ", (Object)this.sequenceNumber);
        }
        packet.setSequence(this.sequenceNumber);
        packet.setSource(this.source);
        for (InetSocketAddress address : this.broadcastAddresses) {
            boolean result = false;
            while (!result) {
                LifxNetworkThrottler.lock();
                result = this.sendPacket(packet, address, this.broadcastKey);
                LifxNetworkThrottler.unlock();
                if (result) continue;
                try {
                    Thread.sleep(NETWORK_INTERVAL);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        ++this.sequenceNumber;
        if (this.sequenceNumber > 255) {
            this.sequenceNumber = 1;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendPacket(Packet packet, InetSocketAddress address, SelectionKey selectedKey) {
        boolean result = false;
        try {
            try {
                block15: {
                    boolean sent;
                    block14: {
                        this.lock.lock();
                        sent = false;
                        if (!true) break block14;
                        if (sent) return result;
                        if (!this.selector.isOpen()) break block15;
                    }
                    do {
                        try {
                            this.selector.selectNow();
                        }
                        catch (IOException e) {
                            this.logger.error("An exception occurred while selecting: {}", (Object)e.getMessage());
                        }
                        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                        for (SelectionKey key : selectedKeys) {
                            if (!key.isValid() || !key.isWritable() || !key.equals(selectedKey)) continue;
                            SelectableChannel channel = key.channel();
                            try {
                                if (channel instanceof DatagramChannel) {
                                    this.logger.trace("{} : Sending packet type '{}' from '{}' to '{}' for '{}' with sequence '{}' and source '{}'", new Object[]{this.macAddress.getHex(), packet.getClass().getSimpleName(), ((InetSocketAddress)((DatagramChannel)channel).getLocalAddress()).toString(), address.toString(), packet.getTarget().getHex(), packet.getSequence(), Long.toString(packet.getSource(), 16)});
                                    ((DatagramChannel)channel).send(packet.bytes(), address);
                                    if (packet.getResponseRequired()) {
                                        this.sentPackets.put(packet.getSequence(), packet);
                                    }
                                    sent = true;
                                    result = true;
                                    continue;
                                }
                                if (!(channel instanceof SocketChannel)) continue;
                                ((SocketChannel)channel).write(packet.bytes());
                            }
                            catch (Exception e) {
                                this.logger.error("An exception occurred while writing data : '{}'", (Object)e.getMessage());
                                break;
                            }
                        }
                        if (sent) return result;
                    } while (this.selector.isOpen());
                }
                return result;
            }
            catch (Exception e) {
                this.logger.error("An exception occurred while communicating with the bulb : '{}'", (Object)e.getMessage());
                this.lock.unlock();
                return result;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handlePacket(Packet packet, InetSocketAddress address) {
        if ((packet.getTarget().equals(this.macAddress) || packet.getTarget().equals(this.broadcastAddress)) && (packet.getSource() == this.source || packet.getSource() == 0L)) {
            this.logger.trace("{} : Packet type '{}' received from '{}' for '{}' with sequence '{}' and source '{}'", new Object[]{this.macAddress.getHex(), packet.getClass().getSimpleName(), address.toString(), packet.getTarget().getHex(), packet.getSequence(), Long.toString(packet.getSource(), 16)});
            Packet originalPacket = this.sentPackets.get(packet.getSequence());
            if (originalPacket != null) {
                this.logger.trace("{} : Packet is a response to a packet of type '{}' with sequence number '{}'", new Object[]{this.macAddress.getHex(), originalPacket.getClass().getSimpleName(), packet.getSequence()});
                this.logger.trace("{} : This response was {}expected", (Object)this.macAddress.getHex(), (Object)(originalPacket.isExpectedResponse(packet.getPacketType()) ? "" : "not "));
                if (originalPacket.isFulfilled(packet)) {
                    this.sentPackets.remove(packet.getSequence());
                    this.logger.trace("{} : There are now {} unanswered packets remaining", (Object)this.macAddress.getHex(), (Object)this.sentPackets.size());
                    for (Packet aPacket : this.sentPackets.values()) {
                        this.logger.trace("{} : sentPackets contains {} with sequence number {}", new Object[]{this.macAddress.getHex(), aPacket.getClass().getSimpleName(), aPacket.getSequence()});
                    }
                }
            }
            if (packet instanceof StateServiceResponse) {
                MACAddress discoveredAddress = ((StateServiceResponse)packet).getTarget();
                if (this.macAddress.equals(discoveredAddress) && (!address.equals(this.ipAddress) && this.port != (int)((StateServiceResponse)packet).getPort() && this.service != ((StateServiceResponse)packet).getService() || this.getThing().getStatus() == ThingStatus.OFFLINE)) {
                    this.port = (int)((StateServiceResponse)packet).getPort();
                    this.service = ((StateServiceResponse)packet).getService();
                    if (this.port == 0) {
                        this.logger.warn("The service with ID '{}' is currently not available", (Object)this.service);
                        this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
                    } else {
                        if (this.unicastChannel != null && this.unicastKey != null) {
                            try {
                                this.unicastChannel.close();
                            }
                            catch (IOException e) {
                                this.logger.error("An exception occurred while closing the channel : '{}'", (Object)e.getMessage());
                            }
                            this.unicastKey.cancel();
                        }
                        try {
                            this.ipAddress = new InetSocketAddress(address.getAddress(), this.port);
                            this.unicastChannel = DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                            this.unicastChannel.configureBlocking(false);
                            this.unicastKey = this.unicastChannel.register(this.selector, 5);
                            this.unicastChannel.connect(this.ipAddress);
                            this.logger.trace("Connected to a bulb via {}", (Object)this.unicastChannel.getLocalAddress().toString());
                        }
                        catch (Exception e) {
                            this.logger.warn("An exception occurred while connectin to the bulb's IP address : '{}'", (Object)e.getMessage());
                            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR);
                            return;
                        }
                        this.updateStatus(ThingStatus.ONLINE);
                        GetLightPowerRequest powerPacket = new GetLightPowerRequest();
                        this.sendPacket(powerPacket);
                        GetRequest colorPacket = new GetRequest();
                        this.sendPacket(colorPacket);
                    }
                }
                return;
            }
            if (packet instanceof StateResponse) {
                this.handleLightStatus((StateResponse)packet);
                return;
            }
            if (packet instanceof StatePowerResponse) {
                this.handlePowerStatus((StatePowerResponse)packet);
                return;
            }
            if (packet instanceof StateLabelResponse) {
                return;
            }
            if (packet instanceof EchoRequestResponse) {
                this.handleEchoRequestReponse((EchoRequestResponse)packet);
                return;
            }
        }
    }

    private int toKelvin(int temperature) {
        return 9000 - (temperature * 65 + 2500);
    }

    private int toPercent(int kelvin) {
        return 100 - (kelvin - 2500) / 65;
    }

    public void handleLightStatus(StateResponse packet) {
        DecimalType hue = new DecimalType((double)((float)(packet.getHue() * 360) / 65535.0f));
        PercentType saturation = new PercentType(Math.round((float)packet.getSaturation() / 65535.0f * 100.0f));
        PercentType brightness = new PercentType(Math.round((float)packet.getBrightness() / 65535.0f * 100.0f));
        PercentType temperature = new PercentType(this.toPercent(packet.getKelvin()));
        this.currentColorState = new HSBType(hue, saturation, brightness);
        this.currentPowerState = packet.getPower();
        this.currentTempState = temperature;
        if (this.currentPowerState == PowerState.OFF) {
            this.updateState("color", (State)new HSBType(hue, saturation, PercentType.ZERO));
            this.updateState("brightness", (State)PercentType.ZERO);
        } else if (this.currentColorState != null) {
            this.updateState("color", (State)this.currentColorState);
            this.updateState("brightness", (State)this.currentColorState.getBrightness());
        } else {
            this.updateState("color", (State)new HSBType(hue, saturation, PercentType.HUNDRED));
            this.updateState("brightness", (State)PercentType.HUNDRED);
        }
        this.updateState("temperature", (State)temperature);
        this.updateStatus(ThingStatus.ONLINE);
    }

    public void handlePowerStatus(StatePowerResponse packet) {
        this.currentPowerState = packet.getState();
        if (packet.getState() == PowerState.OFF) {
            this.updateState("color", (State)new HSBType(this.currentColorState.getHue(), this.currentColorState.getSaturation(), PercentType.ZERO));
            this.updateState("brightness", (State)PercentType.ZERO);
        } else if (this.currentColorState != null) {
            this.updateState("color", (State)this.currentColorState);
            this.updateState("brightness", (State)this.currentColorState.getBrightness());
        } else {
            this.updateState("color", (State)new HSBType(this.currentColorState.getHue(), this.currentColorState.getSaturation(), PercentType.HUNDRED));
            this.updateState("brightness", (State)PercentType.HUNDRED);
        }
        this.updateStatus(ThingStatus.ONLINE);
    }

    public void handleEchoRequestReponse(EchoRequestResponse packet) {
        for (Packet aPacket : this.sentPackets.values()) {
            if (aPacket.getPacketType() != 58) continue;
            this.sentPackets.remove(aPacket.getSequence());
        }
        if (this.getThing().getStatus() == ThingStatus.OFFLINE) {
            this.sentPackets.clear();
            this.updateStatus(ThingStatus.ONLINE);
        }
    }
}

