/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.internal.LifxNetworkThrottler;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetServiceRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetVersionRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketFactory;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketHandler;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Products;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateServiceResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateVersionResponse;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifxLightDiscovery
extends AbstractDiscoveryService {
    private Logger logger = LoggerFactory.getLogger(LifxLightDiscovery.class);
    private List<InetSocketAddress> broadcastAddresses;
    private List<InetAddress> interfaceAddresses;
    private final int BROADCAST_PORT = 56700;
    private static int REFRESH_INTERVAL = 60;
    private static int BROADCAST_TIMEOUT = 5000;
    private static int SELECTOR_TIMEOUT = 10000;
    private int bufferSize = 0;
    private HashMap<MACAddress, StateServiceResponse> serviceResponses = new HashMap();
    private ArrayList<ConnectionSetupParameter> connectionsToSetUp;
    private Selector selector;
    private DatagramChannel broadcastChannel;
    private long source;
    private ScheduledFuture<?> discoveryJob;
    private ScheduledFuture<?> networkJob;
    private Runnable networkRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                long startStamp = System.currentTimeMillis();
                LifxLightDiscovery.this.logger.trace("Entering read loop at {}", (Object)startStamp);
                while (System.currentTimeMillis() - startStamp < (long)SELECTOR_TIMEOUT) {
                    LifxLightDiscovery.this.connectionsToSetUp = new ArrayList();
                    if (LifxLightDiscovery.this.selector == null || !LifxLightDiscovery.this.selector.isOpen()) continue;
                    try {
                        LifxLightDiscovery.this.selector.selectNow();
                    }
                    catch (IOException e) {
                        LifxLightDiscovery.this.logger.error("An exception occurred while selecting: {}", (Object)e.getMessage());
                    }
                    Set<SelectionKey> selectedKeys = LifxLightDiscovery.this.selector.selectedKeys();
                    for (SelectionKey key : selectedKeys) {
                        if (key.isValid() && key.isAcceptable() || key.isValid() && key.isConnectable() || !key.isValid() || !key.isReadable()) continue;
                        SelectableChannel channel = key.channel();
                        InetSocketAddress address = null;
                        int messageLength = 0;
                        ByteBuffer readBuffer = ByteBuffer.allocate(LifxLightDiscovery.this.bufferSize);
                        try {
                            if (channel instanceof DatagramChannel) {
                                address = (InetSocketAddress)((DatagramChannel)channel).receive(readBuffer);
                            } else if (channel instanceof SocketChannel) {
                                address = (InetSocketAddress)((SocketChannel)channel).getRemoteAddress();
                                ((SocketChannel)channel).read(readBuffer);
                            }
                            messageLength = readBuffer.position();
                        }
                        catch (Exception e) {
                            LifxLightDiscovery.this.logger.warn("An exception occurred while reading data : '{}'", (Object)e.getMessage());
                        }
                        if (address != null) {
                            LifxLightDiscovery.this.logger.trace("Receiving data from {}", (Object)address.getAddress().toString());
                            if (LifxLightDiscovery.this.interfaceAddresses.contains(address.getAddress())) continue;
                            readBuffer.rewind();
                            ByteBuffer packetSize = readBuffer.slice();
                            packetSize.position(0);
                            packetSize.limit(2);
                            int size = Packet.FIELD_SIZE.value(packetSize);
                            if (messageLength != size) continue;
                            ByteBuffer packetType = readBuffer.slice();
                            packetType.position(32);
                            packetType.limit(34);
                            int type = Packet.FIELD_PACKET_TYPE.value(packetType);
                            PacketHandler<?> handler = PacketFactory.createHandler(type);
                            if (handler == null) {
                                LifxLightDiscovery.this.logger.trace("Unknown packet type: {} (source: {})", (Object)String.format("0x%02X", type), (Object)address.toString());
                                continue;
                            }
                            Object packet = handler.handle(readBuffer);
                            if (packet == null) {
                                LifxLightDiscovery.this.logger.warn("Handler {} was unable to handle packet", (Object)handler.getClass().getName());
                                continue;
                            }
                            LifxLightDiscovery.this.handlePacket(packet, address);
                            continue;
                        }
                        if (!key.isValid()) continue;
                        key.isWritable();
                    }
                    for (ConnectionSetupParameter csp : LifxLightDiscovery.this.connectionsToSetUp) {
                        NetworkChannel unicastChannel = DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                        ((AbstractSelectableChannel)((Object)unicastChannel)).configureBlocking(false);
                        SelectionKey unicastKey = ((SelectableChannel)((Object)unicastChannel)).register(LifxLightDiscovery.this.selector, 5);
                        ((DatagramChannel)unicastChannel).connect(csp.ipaddress);
                        LifxLightDiscovery.this.logger.trace("Connected to a bulb via {}", (Object)((DatagramChannel)unicastChannel).getLocalAddress().toString());
                        GetVersionRequest versionPacket = new GetVersionRequest();
                        versionPacket.setTarget(csp.target);
                        versionPacket.setSequence(1);
                        versionPacket.setSource(LifxLightDiscovery.this.source);
                        LifxNetworkThrottler.lock();
                        LifxLightDiscovery.this.sendPacket(versionPacket, csp.ipaddress, unicastKey);
                        LifxNetworkThrottler.unlock();
                    }
                }
            }
            catch (Exception e) {
                LifxLightDiscovery.this.logger.error("An exception orccurred while communicating with the bulb : '{}'", (Object)e.getMessage(), (Object)e);
            }
        }
    };

    public LifxLightDiscovery() throws IllegalArgumentException {
        super((Set)Sets.newHashSet((Object[])new ThingTypeUID[]{LifxBindingConstants.THING_TYPE_COLORLIGHT, LifxBindingConstants.THING_TYPE_WHITELIGHT}), 1, true);
    }

    protected void activate(Map<String, Object> configProperties) {
        super.activate(configProperties);
        this.broadcastAddresses = new ArrayList<InetSocketAddress>();
        this.interfaceAddresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            this.logger.debug("An exception occurred while discovering LIFX lights : '{}", (Object)e.getMessage());
        }
        if (networkInterfaces != null) {
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface iface = networkInterfaces.nextElement();
                try {
                    if (!iface.isUp() || iface.isLoopback()) continue;
                    for (InterfaceAddress ifaceAddr : iface.getInterfaceAddresses()) {
                        if (!(ifaceAddr.getAddress() instanceof Inet4Address)) continue;
                        this.logger.debug("Adding '{}' as interface address with MTU {}", (Object)ifaceAddr.getAddress(), (Object)iface.getMTU());
                        if (iface.getMTU() > this.bufferSize) {
                            this.bufferSize = iface.getMTU();
                        }
                        this.interfaceAddresses.add(ifaceAddr.getAddress());
                        if (ifaceAddr.getBroadcast() == null) continue;
                        this.logger.debug("Adding '{}' as broadcast address", (Object)ifaceAddr.getBroadcast());
                        this.broadcastAddresses.add(new InetSocketAddress(ifaceAddr.getBroadcast(), 56700));
                    }
                }
                catch (SocketException e) {
                    this.logger.debug("An exception occurred while discovering LIFX lights : '{}", (Object)e.getMessage());
                }
            }
        }
    }

    protected void deactivate() {
        super.deactivate();
    }

    protected void startBackgroundDiscovery() {
        this.logger.debug("Starting the LIFX device background discovery");
        Runnable discoveryRunnable = new Runnable(){

            @Override
            public void run() {
                LifxLightDiscovery.this.doScan();
            }
        };
        if (this.discoveryJob == null || this.discoveryJob.isCancelled()) {
            this.discoveryJob = scheduler.scheduleWithFixedDelay(discoveryRunnable, 0L, REFRESH_INTERVAL, TimeUnit.SECONDS);
        }
    }

    protected void stopBackgroundDiscovery() {
        this.logger.debug("Stopping LIFX device background discovery");
        if (this.discoveryJob != null && !this.discoveryJob.isCancelled()) {
            this.discoveryJob.cancel(true);
            this.discoveryJob = null;
        }
        if (this.networkJob != null && !this.networkJob.isCancelled()) {
            this.networkJob.cancel(true);
            this.networkJob = null;
        }
    }

    protected void startScan() {
        this.doScan();
    }

    protected synchronized void stopScan() {
        super.stopScan();
        this.removeOlderResults(this.getTimestampOfLastScan());
    }

    protected void doScan() {
        try {
            if (this.selector != null) {
                this.selector.close();
            }
            if (this.broadcastChannel != null) {
                this.broadcastChannel.close();
            }
            this.selector = Selector.open();
            this.broadcastChannel = ((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)true);
            this.broadcastChannel.configureBlocking(false);
            this.broadcastChannel.socket().setSoTimeout(BROADCAST_TIMEOUT);
            this.broadcastChannel.bind(new InetSocketAddress(56700));
            SelectionKey broadcastKey = this.broadcastChannel.register(this.selector, 5);
            this.networkJob = scheduler.schedule(this.networkRunnable, 0L, TimeUnit.MILLISECONDS);
            this.source = UUID.randomUUID().getLeastSignificantBits() & 0xFFFFFFFFL;
            this.logger.debug("The LIFX discovery service will use '{}' as source identifier", (Object)Long.toString(this.source, 16));
            GetServiceRequest packet = new GetServiceRequest();
            this.broadcastPacket(packet, broadcastKey);
        }
        catch (Exception e) {
            this.logger.debug("An exception occurred while discovering LIFX lights : '{}", (Object)e.getMessage());
        }
    }

    private void broadcastPacket(Packet packet, SelectionKey broadcastKey) {
        packet.setSequence(0);
        packet.setSource(this.source);
        for (InetSocketAddress address : this.broadcastAddresses) {
            boolean result = false;
            while (!result) {
                LifxNetworkThrottler.lock();
                result = this.sendPacket(packet, address, broadcastKey);
                LifxNetworkThrottler.unlock();
            }
        }
    }

    private boolean sendPacket(Packet packet, InetSocketAddress address, SelectionKey selectedKey) {
        boolean result = false;
        try {
            boolean sent = false;
            while (!sent) {
                try {
                    this.selector.selectNow();
                }
                catch (IOException e) {
                    this.logger.error("An exception occurred while selecting: {}", (Object)e.getMessage());
                }
                Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                for (SelectionKey key : selectedKeys) {
                    if (!key.isValid() || !key.isWritable() || !key.equals(selectedKey)) continue;
                    SelectableChannel channel = key.channel();
                    try {
                        if (channel instanceof DatagramChannel) {
                            this.logger.trace("Discovery : Sending packet type '{}' from '{}' to '{}' for '{}' with sequence '{}' and source '{}'", new Object[]{packet.getClass().getSimpleName(), ((InetSocketAddress)((DatagramChannel)channel).getLocalAddress()).toString(), address.toString(), packet.getTarget().getHex(), packet.getSequence(), Long.toString(packet.getSource(), 16)});
                            ((DatagramChannel)channel).send(packet.bytes(), address);
                            sent = true;
                            result = true;
                            continue;
                        }
                        if (!(channel instanceof SocketChannel)) continue;
                        ((SocketChannel)channel).write(packet.bytes());
                    }
                    catch (Exception e) {
                        this.logger.error("An exception occurred while writing data : '{}'", (Object)e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while communicating with the bulb : '{}'", (Object)e.getMessage());
        }
        return result;
    }

    private void handlePacket(Packet packet, InetSocketAddress address) {
        this.logger.trace("Discovery : Packet type '{}' received from '{}' for '{}' with sequence '{}' and source '{}'", new Object[]{packet.getClass().getSimpleName(), address.toString(), packet.getTarget().getHex(), packet.getSequence(), Long.toString(packet.getSource(), 16)});
        if (packet.getSource() == this.source || packet.getSource() == 0L) {
            DiscoveryResult discoveryResult;
            StateServiceResponse serviceResponse;
            if (packet instanceof StateServiceResponse) {
                this.serviceResponses.put(packet.getTarget(), (StateServiceResponse)packet);
                int port = (int)((StateServiceResponse)packet).getPort();
                if (port != 0) {
                    try {
                        ConnectionSetupParameter connectionSetup = new ConnectionSetupParameter();
                        connectionSetup.ipaddress = new InetSocketAddress(address.getAddress(), port);
                        connectionSetup.target = packet.getTarget();
                        this.connectionsToSetUp.add(connectionSetup);
                    }
                    catch (Exception e) {
                        this.logger.warn("An exception occurred while connecting to IP address : '{}'", (Object)e.getMessage());
                        return;
                    }
                }
            }
            if (packet instanceof StateVersionResponse && (serviceResponse = this.serviceResponses.get(packet.getTarget())) != null && (discoveryResult = this.createDiscoveryResult(serviceResponse, (StateVersionResponse)packet)) != null) {
                this.thingDiscovered(discoveryResult);
            }
        }
    }

    private DiscoveryResult createDiscoveryResult(StateServiceResponse packet, StateVersionResponse returnedPacket) {
        MACAddress discoveredAddress = packet.getTarget();
        try {
            Products product = Products.getProductFromProductID(returnedPacket.getProduct());
            ThingUID thingUID = this.getUID(discoveredAddress.getAsLabel(), product.isColor());
            String label = "";
            if (StringUtils.isBlank((String)label)) {
                label = product.getName();
            }
            this.logger.trace("Discovered a LIFX light : {}", (Object)label);
            return DiscoveryResultBuilder.create((ThingUID)thingUID).withLabel(label).withProperty("deviceId", (Object)discoveredAddress.getAsLabel()).withRepresentationProperty(discoveredAddress.getAsLabel()).build();
        }
        catch (IllegalArgumentException e) {
            this.logger.trace("Ignoring packet: {}", (Throwable)e);
            return null;
        }
    }

    private ThingUID getUID(String hex, boolean color) {
        if (color) {
            return new ThingUID(LifxBindingConstants.THING_TYPE_COLORLIGHT, hex);
        }
        return new ThingUID(LifxBindingConstants.THING_TYPE_WHITELIGHT, hex);
    }

    private class ConnectionSetupParameter {
        public MACAddress target;
        public InetSocketAddress ipaddress;

        private ConnectionSetupParameter() {
        }
    }
}

