/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.ByteField;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddressField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt8Field;

public abstract class Packet {
    public static final Field<Integer> FIELD_SIZE = new UInt16Field().little();
    public static final Field<Integer> FIELD_PROTOCOL = new UInt16Field().little();
    public static final Field<Long> FIELD_SOURCE = new UInt32Field().little();
    public static final Field<MACAddress> FIELD_TARGET = new MACAddressField();
    public static final Field<ByteBuffer> FIELD_RESERVED_1 = new ByteField(6);
    public static final Field<Integer> FIELD_ACK = new UInt8Field();
    public static final Field<Integer> FIELD_SEQUENCE = new UInt8Field().little();
    public static final Field<ByteBuffer> FIELD_RESERVED_2 = new ByteField(8);
    public static final Field<Integer> FIELD_PACKET_TYPE = new UInt16Field().little();
    public static final Field<ByteBuffer> FIELD_RESERVED_3 = new ByteField(2);
    public static final Field<?>[] PREAMBLE_FIELDS = new Field[]{FIELD_SIZE, FIELD_PROTOCOL, FIELD_SOURCE, FIELD_TARGET, FIELD_RESERVED_1, FIELD_ACK, FIELD_SEQUENCE, FIELD_RESERVED_2, FIELD_PACKET_TYPE, FIELD_RESERVED_3};
    protected int size;
    protected int protocol;
    protected long source;
    protected MACAddress target;
    protected ByteBuffer reserved1;
    protected int ackbyte;
    protected int sequence;
    protected ByteBuffer reserved2;
    protected int packetType;
    protected ByteBuffer reserved3;
    protected long timeStamp;

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getOrigin() {
        return (this.protocol & 0xC000) >> 14;
    }

    public void setOrigin(int origin) {
        this.protocol |= origin << 14;
    }

    public boolean getTagged() {
        return (this.protocol & 0x2000) >> 13 == 1;
    }

    public void setTagged(boolean flag) {
        this.protocol |= (flag ? 1 : 0) << 13;
    }

    public boolean getAddressable() {
        return (this.protocol & 0x1000) >> 12 == 1;
    }

    public void setAddressable(boolean flag) {
        this.protocol |= (flag ? 1 : 0) << 12;
    }

    public int getProtocol() {
        return this.protocol & 0xFFF;
    }

    public void setProtocol(int protocol) {
        this.protocol |= protocol;
    }

    public long getSource() {
        return this.source;
    }

    public void setSource(long source) {
        this.source = source;
    }

    public MACAddress getTarget() {
        return this.target;
    }

    public void setTarget(MACAddress bulbAddress) {
        this.target = bulbAddress;
    }

    public ByteBuffer getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(ByteBuffer reserved2) {
        this.reserved1 = reserved2;
    }

    public boolean getAckRequired() {
        return (this.ackbyte & 2) >> 1 == 1;
    }

    public void setAckRequired(boolean flag) {
        this.ackbyte |= (flag ? 1 : 0) << 1;
    }

    public boolean getResponseRequired() {
        return (this.ackbyte & 1) >> 0 == 1;
    }

    public void setResponseRequired(boolean flag) {
        this.ackbyte |= (flag ? 1 : 0) << 0;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        if (sequence < 255) {
            this.sequence = sequence;
        }
    }

    public ByteBuffer getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(ByteBuffer reserved3) {
        this.reserved2 = reserved3;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public void setPacketType(int packetType) {
        this.packetType = packetType;
    }

    public ByteBuffer getReserved3() {
        return this.reserved3;
    }

    public void setReserved3(ByteBuffer reserved4) {
        this.reserved3 = reserved4;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Packet() {
        this.preambleDefaults();
        this.timeStamp = System.currentTimeMillis();
    }

    protected void parsePreamble(ByteBuffer bytes) {
        this.size = FIELD_SIZE.value(bytes);
        this.protocol = FIELD_PROTOCOL.value(bytes);
        this.source = FIELD_SOURCE.value(bytes);
        this.target = FIELD_TARGET.value(bytes);
        this.reserved1 = FIELD_RESERVED_1.value(bytes);
        this.ackbyte = FIELD_ACK.value(bytes);
        this.sequence = FIELD_SEQUENCE.value(bytes);
        this.reserved2 = FIELD_RESERVED_2.value(bytes);
        this.packetType = FIELD_PACKET_TYPE.value(bytes);
        this.reserved3 = FIELD_RESERVED_3.value(bytes);
    }

    protected int preambleLength() {
        int sum = 0;
        Field<?>[] fieldArray = PREAMBLE_FIELDS;
        int n = PREAMBLE_FIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            Field<?> f = fieldArray[n2];
            sum += f.getLength();
            ++n2;
        }
        return sum;
    }

    protected ByteBuffer preambleBytes() {
        return ByteBuffer.allocate(this.preambleLength()).put(FIELD_SIZE.bytes(this.length())).put(FIELD_PROTOCOL.bytes(this.protocol)).put(FIELD_SOURCE.bytes(this.source)).put(FIELD_TARGET.bytes(this.target)).put(ByteBuffer.allocate(FIELD_RESERVED_1.getLength())).put(FIELD_ACK.bytes(this.ackbyte)).put(FIELD_SEQUENCE.bytes(this.sequence)).put(ByteBuffer.allocate(FIELD_RESERVED_2.getLength())).put(FIELD_PACKET_TYPE.bytes(this.packetType())).put(ByteBuffer.allocate(FIELD_RESERVED_3.getLength()));
    }

    protected void preambleDefaults() {
        this.size = 0;
        this.protocol = 1024;
        this.target = new MACAddress();
        this.sequence = 0;
        this.packetType = this.packetType();
    }

    public abstract int packetType();

    protected abstract int packetLength();

    public void parse(ByteBuffer bytes) {
        bytes.rewind();
        this.parsePreamble(bytes);
        this.parsePacket(bytes);
    }

    protected abstract void parsePacket(ByteBuffer var1);

    public ByteBuffer bytes() {
        ByteBuffer preamble = this.preambleBytes();
        preamble.rewind();
        ByteBuffer packet = this.packetBytes();
        packet.rewind();
        ByteBuffer ret = ByteBuffer.allocate(this.length()).put(preamble).put(packet);
        ret.rewind();
        return ret;
    }

    protected abstract ByteBuffer packetBytes();

    public int length() {
        return this.preambleLength() + this.packetLength();
    }

    public abstract int[] expectedResponses();

    public boolean isExpectedResponse(int type) {
        int[] nArray = this.expectedResponses();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            if (a == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isFulfilled(Packet somePacket) {
        return this.isExpectedResponse(somePacket.getPacketType());
    }
}

