/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.FloatField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class StateWifiInfoResponse
extends Packet {
    public static final int TYPE = 17;
    public static final Field<Float> FIELD_SIGNAL = new FloatField().little();
    public static final Field<Long> FIELD_RX = new UInt32Field().little();
    public static final Field<Long> FIELD_TX = new UInt32Field().little();
    public static final Field<Integer> FIELD_TEMP = new UInt16Field();
    private float signal;
    private long rx;
    private long tx;
    private int mcuTemperature;

    public float getSignal() {
        return this.signal;
    }

    public long getRx() {
        return this.rx;
    }

    public long getTx() {
        return this.tx;
    }

    public int getMcuTemperature() {
        return this.mcuTemperature;
    }

    @Override
    public int packetType() {
        return 17;
    }

    @Override
    protected int packetLength() {
        return 14;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.signal = FIELD_SIGNAL.value(bytes).floatValue();
        this.rx = FIELD_RX.value(bytes);
        this.tx = FIELD_TX.value(bytes);
        this.mcuTemperature = FIELD_TEMP.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_SIGNAL.bytes(Float.valueOf(this.signal))).put(FIELD_RX.bytes(this.rx)).put(FIELD_TX.bytes(this.tx)).put(FIELD_TEMP.bytes(this.mcuTemperature));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

