/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.Arrays;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;

public class ChannelUID
extends UID {
    private static final String CHANNEL_GROUP_SEPERATOR = "#";

    ChannelUID() {
    }

    public ChannelUID(String channelUid) {
        super(channelUid);
    }

    public ChannelUID(ThingUID thingUID, String id) {
        super(ChannelUID.getArray(thingUID, null, id));
    }

    @Deprecated
    public ChannelUID(ThingTypeUID thingTypeUID, ThingUID thingUID, String id) {
        super(ChannelUID.getArray(thingUID, null, id));
    }

    public ChannelUID(ThingUID thingUID, String groupId, String id) {
        super(ChannelUID.getArray(thingUID, groupId, id));
    }

    @Deprecated
    public ChannelUID(ThingTypeUID thingTypeUID, ThingUID thingUID, String groupId, String id) {
        super(ChannelUID.getArray(thingUID, groupId, id));
    }

    @Deprecated
    public ChannelUID(ThingTypeUID thingTypeUID, String thingId, String id) {
        this(thingTypeUID.getBindingId(), thingTypeUID.getId(), thingId, id);
    }

    @Deprecated
    public ChannelUID(String bindingId, String thingTypeId, String thingId, String id) {
        super(bindingId, thingTypeId, thingId, id);
    }

    @Deprecated
    public ChannelUID(String bindingId, String thingTypeId, String thingId, String groupId, String id) {
        super(bindingId, thingTypeId, thingId, ChannelUID.getChannelId(groupId, id));
    }

    private static String[] getArray(ThingUID thingUID, String groupId, String id) {
        String[] result = new String[thingUID.getSegments().length + 1];
        int i = 0;
        while (i < thingUID.getSegments().length) {
            result[i] = thingUID.getSegments()[i];
            ++i;
        }
        result[result.length - 1] = ChannelUID.getChannelId(groupId, id);
        return result;
    }

    private static String getChannelId(String groupId, String id) {
        return groupId != null ? String.valueOf(groupId) + CHANNEL_GROUP_SEPERATOR + id : id;
    }

    public String getId() {
        String[] segments = this.getSegments();
        return segments[segments.length - 1];
    }

    public String getIdWithoutGroup() {
        String[] segments = this.getSegments();
        if (!this.isInGroup()) {
            return segments[segments.length - 1];
        }
        return segments[segments.length - 1].split(CHANNEL_GROUP_SEPERATOR)[1];
    }

    public boolean isInGroup() {
        String[] segments = this.getSegments();
        return segments[segments.length - 1].contains(CHANNEL_GROUP_SEPERATOR);
    }

    public String getGroupId() {
        String[] segments = this.getSegments();
        return this.isInGroup() ? segments[segments.length - 1].split(CHANNEL_GROUP_SEPERATOR)[0] : null;
    }

    @Override
    protected int getMinimalNumberOfSegments() {
        return 4;
    }

    @Override
    protected void validateSegment(String segment, int index, int length) {
        if (index < length - 1) {
            super.validateSegment(segment, index, length);
        } else if (!segment.matches("[A-Za-z0-9_#-]*")) {
            throw new IllegalArgumentException("UID segment '" + segment + "' contains invalid characters. The last segment of the channel UID must match the pattern [A-Za-z0-9_-#]*.");
        }
    }

    public ThingUID getThingUID() {
        return new ThingUID(Arrays.copyOfRange(this.getSegments(), 0, this.getSegments().length - 1));
    }
}

