/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.firmware;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUID;
import org.eclipse.smarthome.core.thing.binding.firmware.ProgressStep;

public final class FirmwareUpdateProgressInfo {
    private FirmwareUID firmwareUID;
    private ProgressStep progressStep;
    private Collection<ProgressStep> sequence;

    protected FirmwareUpdateProgressInfo() {
    }

    FirmwareUpdateProgressInfo(FirmwareUID firmwareUID, ProgressStep progressStep, Collection<ProgressStep> sequence) {
        Preconditions.checkNotNull((Object)firmwareUID, (Object)"Firmware UID must not be null.");
        Preconditions.checkNotNull((Object)((Object)progressStep), (Object)"Progress step must not be null.");
        Preconditions.checkArgument((sequence != null && !sequence.isEmpty() ? 1 : 0) != 0, (Object)"Sequence must not be null or empty.");
        this.firmwareUID = firmwareUID;
        this.progressStep = progressStep;
        this.sequence = sequence;
    }

    public FirmwareUID getFirmwareUID() {
        return this.firmwareUID;
    }

    public ProgressStep getProgressStep() {
        return this.progressStep;
    }

    public Collection<ProgressStep> getSequence() {
        return this.sequence;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.firmwareUID == null ? 0 : this.firmwareUID.hashCode());
        result = 31 * result + (this.progressStep == null ? 0 : this.progressStep.hashCode());
        result = 31 * result + (this.sequence == null ? 0 : this.sequence.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirmwareUpdateProgressInfo other = (FirmwareUpdateProgressInfo)obj;
        if (this.firmwareUID == null ? other.firmwareUID != null : !this.firmwareUID.equals(other.firmwareUID)) {
            return false;
        }
        if (this.progressStep != other.progressStep) {
            return false;
        }
        return !(this.sequence == null ? other.sequence != null : !this.sequence.equals(other.sequence));
    }

    public String toString() {
        return "FirmwareUpdateProgressInfo [firmwareUID=" + this.firmwareUID + ", progressStep=" + (Object)((Object)this.progressStep) + ", sequence=" + this.sequence + "]";
    }
}

