/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.core.common.registry.Provider;
import org.eclipse.smarthome.core.common.registry.ProviderChangeListener;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.i18n.LocaleProvider;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemProvider;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.TypeResolver;

public class ChannelItemProvider
implements ItemProvider {
    private Set<ProviderChangeListener<Item>> listeners = new HashSet<ProviderChangeListener<Item>>();
    private LocaleProvider localeProvider;
    private ThingRegistry thingRegistry;
    private ItemChannelLinkRegistry linkRegistry;
    private ItemRegistry itemRegistry;
    private Set<ItemFactory> itemFactories = new HashSet<ItemFactory>();
    private Map<String, Item> items = null;
    private boolean enabled = true;
    RegistryChangeListener<Thing> thingRegistryListener = new RegistryChangeListener<Thing>(){

        public void added(Thing element) {
            for (Channel channel : element.getChannels()) {
                for (ItemChannelLink link : ChannelItemProvider.this.linkRegistry.getLinks(channel.getUID())) {
                    ChannelItemProvider.this.createItemForLink(link);
                }
            }
        }

        public void removed(Thing element) {
            ChannelItemProvider.this.removeItem(element.getUID().toString());
        }

        public void updated(Thing oldElement, Thing element) {
            this.removed(oldElement);
            this.added(element);
        }
    };
    RegistryChangeListener<ItemChannelLink> linkRegistryListener = new RegistryChangeListener<ItemChannelLink>(){

        public void added(ItemChannelLink element) {
            ChannelItemProvider.this.createItemForLink(element);
        }

        public void removed(ItemChannelLink element) {
            ChannelItemProvider.this.removeItem(element.getItemName());
        }

        public void updated(ItemChannelLink oldElement, ItemChannelLink element) {
            this.removed(oldElement);
            this.added(element);
        }
    };
    RegistryChangeListener<Item> itemRegistryListener = new RegistryChangeListener<Item>(){

        public void added(Item element) {
            Item oldElement;
            if (!ChannelItemProvider.this.items.values().contains(element) && (oldElement = (Item)ChannelItemProvider.this.items.remove(element.getName())) != null) {
                for (ProviderChangeListener listener : ChannelItemProvider.this.listeners) {
                    listener.removed((Provider)ChannelItemProvider.this, (Object)oldElement);
                }
            }
        }

        public void removed(Item element) {
            for (ChannelUID uid : ChannelItemProvider.this.linkRegistry.getBoundChannels(element.getName())) {
                for (ItemChannelLink link : ChannelItemProvider.this.linkRegistry.getLinks(uid)) {
                    if (ChannelItemProvider.this.itemRegistry.get((Object)link.getItemName()) != null) continue;
                    ChannelItemProvider.this.createItemForLink(link);
                }
            }
        }

        public void updated(Item oldElement, Item element) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Item> getAll() {
        if (!this.enabled) {
            return Collections.emptySet();
        }
        ChannelItemProvider channelItemProvider = this;
        synchronized (channelItemProvider) {
            if (this.items == null) {
                this.items = new HashMap<String, Item>();
                for (ItemChannelLink link : this.linkRegistry.getAll()) {
                    this.createItemForLink(link);
                }
            }
        }
        return this.items.values();
    }

    public void addProviderChangeListener(ProviderChangeListener<Item> listener) {
        this.listeners.add(listener);
        for (Item item : this.getAll()) {
            listener.added((Provider)this, (Object)item);
        }
    }

    public void removeProviderChangeListener(ProviderChangeListener<Item> listener) {
        this.listeners.remove(listener);
    }

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry linkRegistry) {
        this.linkRegistry = linkRegistry;
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry linkRegistry) {
        this.linkRegistry = null;
    }

    protected void activate(Map<String, Object> properties) {
        String enabled;
        if (properties != null && "false".equalsIgnoreCase(enabled = (String)properties.get("enabled"))) {
            this.enabled = false;
        }
        if (this.enabled) {
            for (ProviderChangeListener<Item> listener : this.listeners) {
                for (Item item : this.getAll()) {
                    listener.added((Provider)this, (Object)item);
                }
            }
            this.linkRegistry.addRegistryChangeListener(this.linkRegistryListener);
            this.itemRegistry.addRegistryChangeListener(this.itemRegistryListener);
            this.thingRegistry.addRegistryChangeListener(this.thingRegistryListener);
        } else {
            for (ProviderChangeListener<Item> listener : this.listeners) {
                for (Item item : this.getAll()) {
                    listener.removed((Provider)this, (Object)item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        this.itemRegistry.removeRegistryChangeListener(this.itemRegistryListener);
        this.linkRegistry.removeRegistryChangeListener(this.linkRegistryListener);
        this.thingRegistry.removeRegistryChangeListener(this.thingRegistryListener);
        ChannelItemProvider channelItemProvider = this;
        synchronized (channelItemProvider) {
            this.items = null;
        }
    }

    private void createItemForLink(ItemChannelLink link) {
        if (this.itemRegistry.get((Object)link.getItemName()) != null) {
            return;
        }
        Channel channel = this.thingRegistry.getChannel(link.getUID());
        if (channel != null) {
            GenericItem item = null;
            for (ItemFactory itemFactory : this.itemFactories) {
                item = itemFactory.createItem(channel.getAcceptedItemType(), link.getItemName());
                if (item != null) break;
            }
            if (item != null && item instanceof GenericItem) {
                GenericItem genericItem = item;
                genericItem.setLabel(this.getLabel(channel));
                genericItem.setCategory(this.getCategory(channel));
                genericItem.addTags(channel.getDefaultTags());
            }
            if (item != null) {
                this.items.put(item.getName(), (Item)item);
                for (ProviderChangeListener providerChangeListener : this.listeners) {
                    providerChangeListener.added((Provider)this, (Object)item);
                }
            }
        }
    }

    private String getCategory(Channel channel) {
        ChannelType channelType = TypeResolver.resolve(channel.getChannelTypeUID(), this.localeProvider.getLocale());
        if (channelType != null) {
            return channelType.getCategory();
        }
        return null;
    }

    private String getLabel(Channel channel) {
        if (channel.getLabel() != null) {
            return channel.getLabel();
        }
        Locale locale = this.localeProvider.getLocale();
        ChannelType channelType = TypeResolver.resolve(channel.getChannelTypeUID(), locale);
        if (channelType != null) {
            return channelType.getLabel();
        }
        return null;
    }

    private void removeItem(String key) {
        if (!this.enabled) {
            return;
        }
        Item item = this.items.get(key);
        if (item != null) {
            this.items.remove(key);
            for (ProviderChangeListener<Item> listener : this.listeners) {
                listener.removed((Provider)this, (Object)item);
            }
            this.items.remove(key);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

