/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.defaultscope.internal;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.slf4j.LoggerFactory;

public class ScriptBusEvent {
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;

    ScriptBusEvent(ItemRegistry itemRegistry, EventPublisher eventPublisher) {
        this.itemRegistry = itemRegistry;
        this.eventPublisher = eventPublisher;
    }

    public void dispose() {
        this.itemRegistry = null;
        this.eventPublisher = null;
    }

    public Object sendCommand(Item item, String commandString) {
        if (item != null) {
            return this.sendCommand(item.getName(), commandString);
        }
        return null;
    }

    public Object sendCommand(Item item, Number number) {
        if (item != null && number != null) {
            return this.sendCommand(item.getName(), number.toString());
        }
        return null;
    }

    public Object sendCommand(String itemName, String commandString) {
        if (this.eventPublisher != null && this.itemRegistry != null) {
            try {
                Item item = this.itemRegistry.getItem(itemName);
                Command command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandString);
                this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command));
            }
            catch (ItemNotFoundException itemNotFoundException) {
                LoggerFactory.getLogger(ScriptBusEvent.class).warn("Item '" + itemName + "' does not exist.");
            }
        }
        return null;
    }

    public Object sendCommand(Item item, Command command) {
        if (this.eventPublisher != null && item != null) {
            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command));
        }
        return null;
    }

    public Object postUpdate(Item item, Number state) {
        if (item != null && state != null) {
            return this.postUpdate(item.getName(), state.toString());
        }
        return null;
    }

    public Object postUpdate(Item item, String stateAsString) {
        if (item != null) {
            return this.postUpdate(item.getName(), stateAsString);
        }
        return null;
    }

    public Object postUpdate(String itemName, String stateString) {
        if (this.eventPublisher != null && this.itemRegistry != null) {
            try {
                Item item = this.itemRegistry.getItem(itemName);
                State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateString);
                this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)itemName, (State)state));
            }
            catch (ItemNotFoundException itemNotFoundException) {
                LoggerFactory.getLogger(ScriptBusEvent.class).warn("Item '" + itemName + "' does not exist.");
            }
        }
        return null;
    }

    public Object postUpdate(Item item, State state) {
        if (this.eventPublisher != null && item != null) {
            this.eventPublisher.post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)state));
        }
        return null;
    }

    public Map<Item, State> storeStates(Item ... items) {
        HashMap statesMap = Maps.newHashMap();
        if (items != null) {
            Item[] itemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getAllMembers()) {
                        statesMap.put(member, member.getState());
                    }
                } else {
                    statesMap.put(item, item.getState());
                }
                ++n2;
            }
        }
        return statesMap;
    }

    public Object restoreStates(Map<Item, State> statesMap) {
        if (statesMap != null) {
            for (Map.Entry<Item, State> entry : statesMap.entrySet()) {
                if (entry.getValue() instanceof Command) {
                    this.sendCommand(entry.getKey(), (Command)entry.getValue());
                    continue;
                }
                this.postUpdate(entry.getKey(), entry.getValue());
            }
        }
        return null;
    }
}

