/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.audio;

public class AudioFormat {
    private final String codec;
    private final String container;
    private final Boolean bigEndian;
    private final Integer bitDepth;
    private final Integer bitRate;
    private final Long frequency;

    public AudioFormat(String container, String codec, Boolean bigEndian, Integer bitDepth, Integer bitRate, Long frequency) {
        this.container = container;
        this.codec = codec;
        this.bigEndian = bigEndian;
        this.bitDepth = bitDepth;
        this.bitRate = bitRate;
        this.frequency = frequency;
    }

    public String getCodec() {
        return this.codec;
    }

    public String getContainer() {
        return this.container;
    }

    public Boolean isBigEndian() {
        return this.bigEndian;
    }

    public Integer getBitDepth() {
        return this.bitDepth;
    }

    public Integer getBitRate() {
        return this.bitRate;
    }

    public Long getFrequency() {
        return this.frequency;
    }

    boolean isCompatible(AudioFormat audioFormat) {
        if (audioFormat == null) {
            return false;
        }
        if (this.getContainer() != null && this.getContainer() != audioFormat.getContainer()) {
            return false;
        }
        if (this.getCodec() != null && this.getCodec() != audioFormat.getCodec()) {
            return false;
        }
        if (this.isBigEndian() != null && this.isBigEndian() != audioFormat.isBigEndian()) {
            return false;
        }
        if (this.getBitDepth() != null && this.getBitDepth() != audioFormat.getBitDepth()) {
            return false;
        }
        if (this.getBitRate() != null && this.getBitRate() != audioFormat.getBitRate()) {
            return false;
        }
        return this.getFrequency() == null || this.getFrequency() == audioFormat.getFrequency();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AudioFormat) {
            AudioFormat format = (AudioFormat)obj;
            if (format.getCodec() != this.getCodec()) {
                return false;
            }
            if (format.getContainer() != this.getContainer()) {
                return false;
            }
            if (format.isBigEndian() != this.isBigEndian()) {
                return false;
            }
            if (format.getBitDepth() != this.getBitDepth()) {
                return false;
            }
            if (format.getBitRate() != this.getBitRate()) {
                return false;
            }
            return format.getFrequency() == this.getFrequency();
        }
        return super.equals(obj);
    }
}

